/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import javax.resource.spi.work.WorkException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.routing.Aggregator;
import org.mule.api.routing.MessageInfoMapping;
import org.mule.api.service.Service;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.routing.correlation.EventCorrelator;
import org.mule.routing.correlation.EventCorrelatorCallback;

public abstract class AbstractAggregator
extends AbstractInterceptingMessageProcessor
implements Initialisable,
MuleContextAware,
FlowConstructAware,
Aggregator {
    protected EventCorrelator eventCorrelator;
    protected MuleContext muleContext;
    protected FlowConstruct flowConstruct;
    protected MessageInfoMapping messageInfoMapping;
    private long timeout = 0L;
    private boolean failOnTimeout = true;

    public void initialise() throws InitialisationException {
        Service service;
        if (this.messageInfoMapping == null) {
            this.messageInfoMapping = this.flowConstruct.getMessageInfoMapping();
        }
        this.eventCorrelator = new EventCorrelator(this.getCorrelatorCallback(this.muleContext), this.next, this.messageInfoMapping, this.muleContext);
        if (this.flowConstruct instanceof Service && (service = (Service)this.flowConstruct).getAsyncReplyMessageSource().getMessageProcessors().contains(this)) {
            this.failOnTimeout = service.getAsyncReplyMessageSource().isFailOnTimeout();
        }
        this.eventCorrelator.setTimeout(this.timeout);
        this.eventCorrelator.setFailOnTimeout(this.isFailOnTimeout());
        if (this.timeout != 0L) {
            try {
                this.eventCorrelator.enableTimeoutMonitor();
            }
            catch (WorkException e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    protected abstract EventCorrelatorCallback getCorrelatorCallback(MuleContext var1);

    public MuleEvent process(MuleEvent event) throws MuleException {
        MuleEvent result = this.eventCorrelator.process(event);
        if (result == null) {
            return null;
        }
        return this.processNext(result);
    }

    public void expireAggregation(String groupId) {
        this.eventCorrelator.forceGroupExpiry(groupId);
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public boolean isFailOnTimeout() {
        return this.failOnTimeout;
    }

    public void setFailOnTimeout(boolean failOnTimeout) {
        this.failOnTimeout = failOnTimeout;
    }

    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }

    public void setMessageInfoMapping(MessageInfoMapping messageInfoMapping) {
        this.messageInfoMapping = messageInfoMapping;
    }
}

