/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor.builder;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.InterceptingMessageProcessor;
import org.mule.api.processor.MessageProcessor;
import org.mule.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptingChainCompositeMessageProcessor
implements MessageProcessor,
Lifecycle,
FlowConstructAware,
MuleContextAware {
    private Log log;
    private String name;
    private MessageProcessor firstInChain;
    private List<MessageProcessor> allProcessors;

    public InterceptingChainCompositeMessageProcessor(InterceptingMessageProcessor firstInChain, List<MessageProcessor> allProcessors, String name) {
        this.name = name;
        this.firstInChain = firstInChain;
        this.allProcessors = allProcessors;
        this.log = LogFactory.getLog(InterceptingChainCompositeMessageProcessor.class);
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Invoking " + this + " with event " + event));
        }
        return this.firstInChain.process(event);
    }

    @Override
    public void initialise() throws InitialisationException {
        for (MessageProcessor processor : this.allProcessors) {
            if (!(processor instanceof Initialisable)) continue;
            ((Initialisable)((Object)processor)).initialise();
        }
    }

    @Override
    public void start() throws MuleException {
        for (MessageProcessor processor : this.allProcessors) {
            if (!(processor instanceof Startable)) continue;
            ((Startable)((Object)processor)).start();
        }
    }

    @Override
    public void stop() throws MuleException {
        for (MessageProcessor processor : this.allProcessors) {
            if (!(processor instanceof Stoppable)) continue;
            ((Stoppable)((Object)processor)).stop();
        }
    }

    @Override
    public void dispose() {
        for (MessageProcessor processor : this.allProcessors) {
            if (!(processor instanceof Disposable)) continue;
            ((Disposable)((Object)processor)).dispose();
        }
        this.firstInChain = null;
        this.allProcessors.clear();
    }

    @Override
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        for (MessageProcessor processor : this.allProcessors) {
            if (!(processor instanceof FlowConstructAware)) continue;
            ((FlowConstructAware)((Object)processor)).setFlowConstruct(flowConstruct);
        }
    }

    @Override
    public void setMuleContext(MuleContext context) {
        for (MessageProcessor processor : this.allProcessors) {
            if (!(processor instanceof MuleContextAware)) continue;
            ((MuleContextAware)((Object)processor)).setMuleContext(context);
        }
    }

    public String toString() {
        Iterator<MessageProcessor> mpIterator;
        StringBuffer string = new StringBuffer();
        string.append("InterceptingChainCompositeMessageProcessor ");
        if (this.name != null) {
            string.append(" '" + this.name + "' ");
        }
        if ((mpIterator = this.allProcessors.iterator()).hasNext()) {
            string.append("\n[ ");
            while (mpIterator.hasNext()) {
                MessageProcessor mp = mpIterator.next();
                string.append("\n  " + StringUtils.replace((String)mp.toString(), (String)"\n", (String)"\n  "));
                if (!mpIterator.hasNext()) continue;
                string.append(", ");
            }
            string.append("\n]");
        }
        return string.toString();
    }
}

