/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.InterceptingMessageProcessor;
import org.mule.api.processor.MessageProcessor;
import org.mule.util.ObjectUtils;

public abstract class AbstractInterceptingMessageProcessor
implements InterceptingMessageProcessor {
    protected Log logger = LogFactory.getLog(this.getClass());
    protected MessageProcessor next;

    public void setListener(MessageProcessor next) {
        this.next = next;
    }

    protected MuleEvent processNext(MuleEvent event) throws MuleException {
        if (this.next == null) {
            return event;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Invoking next MessageProcessor: '" + this.next.getClass().getName() + "' "));
        }
        if (this.next instanceof OutboundEndpoint) {
            event = new DefaultMuleEvent(event.getMessage(), (OutboundEndpoint)this.next, event.getSession());
        }
        return this.next.process(event);
    }

    public String toString() {
        return ObjectUtils.toString(this);
    }
}

