/*
 * Decompiled with CFR 0.152.
 */
package org.mule.message;

import java.io.Serializable;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.transport.PropertyScope;
import org.mule.message.BaseMessageDTO;

public class DefaultMuleMessageDTO
extends BaseMessageDTO {
    private String replyTo;

    public DefaultMuleMessageDTO() {
    }

    public DefaultMuleMessageDTO(Serializable message) {
        super(message);
    }

    public DefaultMuleMessageDTO(MuleMessage message) {
        super(message.getPayload());
        this.encodePropertiesForScope(PropertyScope.INBOUND, message);
        this.encodePropertiesForScope(PropertyScope.OUTBOUND, message);
        this.encodePropertiesForScope(PropertyScope.INVOCATION, message);
        this.encodePropertiesForScope(PropertyScope.SESSION, message);
        if (message.getReplyTo() != null) {
            this.setReplyTo(message.getReplyTo().toString());
        }
    }

    protected void encodePropertiesForScope(PropertyScope scope, MuleMessage message) {
        for (String key : message.getPropertyNames(scope)) {
            this.setProperty(String.format("%s#%s", scope.getScopeName(), key), message.getProperty(key, scope));
        }
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public Object getData() {
        return this.getPayload();
    }

    public void setData(Object data) {
        this.setPayload(data);
    }

    public void addPropertiesTo(MuleMessage message) {
        for (String s : this.properties.keySet()) {
            int i;
            String prefix = s.substring(0, i = s.indexOf("#"));
            if (prefix.equals(PropertyScope.OUTBOUND.getScopeName())) {
                message.setOutboundProperty(s.substring(i + 1), this.getProperty(s));
                continue;
            }
            if (prefix.equals(PropertyScope.SESSION.getScopeName())) {
                message.setProperty(s.substring(i + 1), this.getProperty(s), PropertyScope.SESSION);
                continue;
            }
            message.setInvocationProperty(s.substring(i + 1), this.getProperty(s));
        }
        message.setReplyTo(this.getReplyTo());
    }

    public MuleMessage toMuleMessage(MuleContext context) {
        DefaultMuleMessage message = new DefaultMuleMessage(this.getPayload(), context);
        this.addPropertiesTo(message);
        return message;
    }
}

