/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api;

import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.config.MuleManifest;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.Message;
import org.mule.transport.NullPayload;
import org.mule.util.StringUtils;

public class MessagingException
extends MuleException {
    private static final long serialVersionUID = 6941498759267936649L;
    protected final transient MuleMessage muleMessage;
    protected final transient MuleEvent event;

    @Deprecated
    public MessagingException(Message message, MuleMessage muleMessage) {
        this.muleMessage = muleMessage;
        this.event = null;
        this.setMessage(this.generateMessage(message));
    }

    public MessagingException(Message message, MuleEvent event) {
        this.event = event;
        this.muleMessage = event != null ? event.getMessage() : null;
        this.setMessage(this.generateMessage(message));
    }

    @Deprecated
    public MessagingException(Message message, MuleMessage muleMessage, Throwable cause) {
        super(cause);
        this.muleMessage = muleMessage;
        this.event = null;
        this.setMessage(this.generateMessage(message));
    }

    public MessagingException(Message message, MuleEvent event, Throwable cause) {
        super(cause);
        this.event = event;
        this.muleMessage = event != null ? event.getMessage() : null;
        this.setMessage(this.generateMessage(message));
    }

    @Deprecated
    public MessagingException(MuleMessage muleMessage, Throwable cause) {
        super(cause);
        this.muleMessage = muleMessage;
        this.event = null;
        this.setMessage(this.generateMessage(this.getI18nMessage()));
    }

    public MessagingException(MuleEvent event, Throwable cause) {
        super(cause);
        this.event = event;
        this.muleMessage = event != null ? event.getMessage() : null;
        this.setMessage(this.generateMessage(this.getI18nMessage()));
    }

    private String generateMessage(Message message) {
        StringBuffer buf = new StringBuffer(80);
        if (message != null) {
            buf.append(message.getMessage()).append(". ");
        }
        if (this.muleMessage != null) {
            Object payload = this.muleMessage.getPayload();
            if (payload == null) {
                payload = NullPayload.getInstance();
            }
            buf.append(CoreMessages.messageIsOfType(payload.getClass()).getMessage());
            this.addInfo("Payload", StringUtils.abbreviate((String)payload.toString(), (int)1000));
        } else {
            buf.append("The current MuleMessage is null! Please report this to ").append(MuleManifest.getDevListEmail());
            this.addInfo("Payload", NullPayload.getInstance().toString());
        }
        return buf.toString();
    }

    public MuleMessage getMuleMessage() {
        if (this.event != null && this.muleMessage == null) {
            return this.event.getMessage();
        }
        return this.muleMessage;
    }

    public MuleEvent getEvent() {
        return this.event;
    }
}

