/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleEventContext;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleEvent;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;

public final class RequestContext {
    public static final boolean SAFE = true;
    public static final boolean UNSAFE = true;
    private static final boolean DEFAULT_ACTION = true;
    private static final ThreadLocal currentEvent = new ThreadLocal();

    protected RequestContext() {
    }

    public static MuleEventContext getEventContext() {
        MuleEvent event = RequestContext.getEvent();
        if (event != null) {
            return new DefaultMuleEventContext(event);
        }
        return null;
    }

    public static MuleEvent getEvent() {
        return (MuleEvent)currentEvent.get();
    }

    public static MuleEvent setEvent(MuleEvent event) {
        return RequestContext.internalSetEvent(RequestContext.newEvent(event, true));
    }

    protected static MuleEvent internalSetEvent(MuleEvent event) {
        currentEvent.set(event);
        return event;
    }

    protected static MuleMessage internalRewriteEvent(MuleMessage message, boolean safe) {
        MuleEvent event;
        if (message != null && (event = RequestContext.getEvent()) != null) {
            MuleMessage copy = RequestContext.newMessage(message, safe);
            DefaultMuleEvent newEvent = new DefaultMuleEvent(copy, event);
            if (safe) {
                RequestContext.resetAccessControl(copy);
            }
            RequestContext.internalSetEvent(newEvent);
            return copy;
        }
        return message;
    }

    public static void clear() {
        RequestContext.setEvent(null);
    }

    public static void setExceptionPayload(ExceptionPayload exceptionPayload) {
        MuleEvent newEvent = RequestContext.newEvent(RequestContext.getEvent(), true);
        newEvent.getMessage().setExceptionPayload(exceptionPayload);
        RequestContext.internalSetEvent(newEvent);
    }

    public static ExceptionPayload getExceptionPayload() {
        return RequestContext.getEvent().getMessage().getExceptionPayload();
    }

    public static MuleMessage safeMessageCopy(MuleMessage message) {
        return RequestContext.newMessage(message, true);
    }

    public static MuleEvent cloneAndUpdateEventEndpoint(MuleEvent event, MessageProcessor target) {
        return RequestContext.updateEventEndpoint(RequestContext.newEvent(event, true), target);
    }

    public static MuleEvent updateEventEndpoint(MuleEvent event, MessageProcessor target) {
        if (target instanceof OutboundEndpoint) {
            return new DefaultMuleEvent(event.getMessage(), (ImmutableEndpoint)((Object)target), event.getSession());
        }
        return event;
    }

    protected static MuleEvent newEvent(MuleEvent event, boolean safe) {
        if (safe && event instanceof ThreadSafeAccess) {
            return (MuleEvent)((Object)((ThreadSafeAccess)((Object)event)).newThreadCopy());
        }
        return event;
    }

    protected static MuleMessage newMessage(MuleMessage message, boolean safe) {
        if (safe && message instanceof ThreadSafeAccess) {
            return (MuleMessage)((Object)((ThreadSafeAccess)((Object)message)).newThreadCopy());
        }
        return message;
    }

    protected static void resetAccessControl(Object object) {
        if (object instanceof ThreadSafeAccess) {
            ((ThreadSafeAccess)object).resetAccessControl();
        }
    }
}

