/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import java.util.List;
import javax.resource.spi.work.Work;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.transaction.TransactionCallback;
import org.mule.api.transport.Connector;
import org.mule.transaction.TransactionTemplate;
import org.mule.transport.AbstractPollingMessageReceiver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TransactedPollingMessageReceiver
extends AbstractPollingMessageReceiver {
    private boolean receiveMessagesInTransaction = true;
    private boolean useMultipleReceivers = true;

    public TransactedPollingMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws CreateException {
        super(connector, flowConstruct, endpoint);
        this.setReceiveMessagesInTransaction(endpoint.getTransactionConfig().isTransacted());
    }

    public TransactedPollingMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint, long frequency) throws CreateException {
        this(connector, flowConstruct, endpoint);
        this.setFrequency(frequency);
    }

    public boolean isReceiveMessagesInTransaction() {
        return this.receiveMessagesInTransaction;
    }

    public void setReceiveMessagesInTransaction(boolean useTx) {
        this.receiveMessagesInTransaction = useTx;
    }

    public boolean isUseMultipleTransactedReceivers() {
        return this.useMultipleReceivers;
    }

    public void setUseMultipleTransactedReceivers(boolean useMultiple) {
        this.useMultipleReceivers = useMultiple;
    }

    @Override
    public void doStart() throws MuleException {
        this.setUseMultipleTransactedReceivers(this.connector.isCreateMultipleTransactedReceivers());
        ThreadingProfile tp = this.connector.getReceiverThreadingProfile();
        int numReceiversToStart = 1;
        if (this.isReceiveMessagesInTransaction() && this.isUseMultipleTransactedReceivers() && tp.isDoThreading()) {
            numReceiversToStart = this.connector.getNumberOfConcurrentTransactedReceivers();
        }
        for (int i = 0; i < numReceiversToStart; ++i) {
            super.doStart();
        }
    }

    @Override
    public void poll() throws Exception {
        TransactionTemplate tt = new TransactionTemplate(this.endpoint.getTransactionConfig(), this.connector.getExceptionListener(), this.connector.getMuleContext());
        if (this.isReceiveMessagesInTransaction()) {
            TransactionCallback cb = new TransactionCallback(){

                public Object doInTransaction() throws Exception {
                    List<MuleMessage> messages = TransactedPollingMessageReceiver.this.getMessages();
                    if (messages != null && messages.size() > 0) {
                        for (MuleMessage message : messages) {
                            TransactedPollingMessageReceiver.this.processMessage(message);
                        }
                    }
                    return null;
                }
            };
            tt.execute(cb);
        } else {
            List<MuleMessage> messages = this.getMessages();
            if (messages != null && messages.size() > 0) {
                CountDownLatch countdown = new CountDownLatch(messages.size());
                for (MuleMessage message : messages) {
                    try {
                        this.getWorkManager().scheduleWork(new MessageProcessorWorker(tt, countdown, message));
                    }
                    catch (Exception e) {
                        countdown.countDown();
                        throw e;
                    }
                }
                countdown.await();
            }
        }
    }

    protected abstract List<MuleMessage> getMessages() throws Exception;

    protected abstract void processMessage(Object var1) throws Exception;

    protected class MessageProcessorWorker
    implements Work,
    TransactionCallback {
        private final TransactionTemplate tt;
        private final Object message;
        private final CountDownLatch latch;

        public MessageProcessorWorker(TransactionTemplate tt, CountDownLatch latch, Object message) {
            this.tt = tt;
            this.message = message;
            this.latch = latch;
        }

        public void release() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.tt.execute(this);
            }
            catch (Exception e) {
                TransactedPollingMessageReceiver.this.handleException(e);
            }
            finally {
                this.latch.countDown();
            }
        }

        public Object doInTransaction() throws Exception {
            TransactedPollingMessageReceiver.this.processMessage(this.message);
            return null;
        }
    }
}

