/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import org.mule.DefaultMuleEvent;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.context.WorkManager;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.routing.ResponseRouterCollection;
import org.mule.api.service.Service;
import org.mule.api.transport.DispatchException;
import org.mule.api.transport.MessageDispatcher;
import org.mule.transport.AbstractConnectable;
import org.mule.transport.ConnectableLifecycleManager;

public abstract class AbstractMessageDispatcher
extends AbstractConnectable
implements MessageDispatcher {
    public AbstractMessageDispatcher(OutboundEndpoint endpoint) {
        super(endpoint);
    }

    protected ConnectableLifecycleManager createLifecycleManager() {
        return new ConnectableLifecycleManager<AbstractMessageDispatcher>(this.getDispatcherName(), this);
    }

    protected String getDispatcherName() {
        return this.getConnector().getName() + ".dispatcher." + System.identityHashCode(this);
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        DefaultMuleEvent result = null;
        try {
            this.connect();
            if (this.endpoint.isSynchronous()) {
                MuleMessage resultMessage = this.doSend(event);
                if (resultMessage != null) {
                    result = new DefaultMuleEvent(resultMessage, event);
                }
            } else {
                this.doDispatch(event);
            }
        }
        catch (MuleException muleException) {
            throw muleException;
        }
        catch (Exception e) {
            throw new DispatchException(event.getMessage(), this.endpoint, (Throwable)e);
        }
        return result;
    }

    @Deprecated
    protected boolean returnResponse(MuleEvent event) {
        return this.returnResponse(event, false);
    }

    protected boolean returnResponse(MuleEvent event, boolean doSend) {
        boolean remoteSync = false;
        if (event.getEndpoint().getConnector().isResponseEnabled()) {
            boolean bl = remoteSync = event.getEndpoint().isSynchronous() || doSend;
            if (remoteSync && event.getFlowConstruct() != null && event.getFlowConstruct() instanceof Service) {
                ResponseRouterCollection responseRouters = ((Service)event.getFlowConstruct()).getResponseRouter();
                remoteSync = responseRouters == null || !responseRouters.hasEndpoints();
            }
        }
        if (!remoteSync) {
            event.getMessage().removeProperty("MULE_REMOTE_SYNC");
        }
        return remoteSync;
    }

    protected WorkManager getWorkManager() {
        try {
            return this.connector.getDispatcherWorkManager();
        }
        catch (MuleException e) {
            this.logger.error((Object)e);
            return null;
        }
    }

    public OutboundEndpoint getEndpoint() {
        return (OutboundEndpoint)super.getEndpoint();
    }

    protected abstract void doDispatch(MuleEvent var1) throws Exception;

    protected abstract MuleMessage doSend(MuleEvent var1) throws Exception;
}

