/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import java.beans.ExceptionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.context.WorkManager;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleCallback;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.lifecycle.LifecycleState;
import org.mule.api.lifecycle.LifecycleStateEnabled;
import org.mule.api.lifecycle.StartException;
import org.mule.api.retry.RetryCallback;
import org.mule.api.retry.RetryContext;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.api.transport.Connectable;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MuleMessageFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.Message;
import org.mule.config.i18n.MessageFactory;
import org.mule.context.notification.ConnectionNotification;
import org.mule.transport.AbstractConnector;
import org.mule.transport.ConnectableLifecycleManager;
import org.mule.util.ClassUtils;
import org.mule.util.concurrent.WaitableBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConnectable<O>
implements Connectable,
ExceptionListener,
LifecycleStateEnabled {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected ImmutableEndpoint endpoint;
    protected final AbstractConnector connector;
    protected RetryPolicyTemplate retryTemplate;
    protected MuleMessageFactory muleMessageFactory = null;
    protected final WaitableBoolean connected = new WaitableBoolean(false);
    protected final WaitableBoolean connecting = new WaitableBoolean(false);
    protected volatile boolean startOnConnect = false;
    protected ConnectableLifecycleManager<O> lifecycleManager;

    public AbstractConnectable(ImmutableEndpoint endpoint) {
        this.endpoint = endpoint;
        this.connector = (AbstractConnector)endpoint.getConnector();
        this.lifecycleManager = this.createLifecycleManager();
    }

    protected abstract ConnectableLifecycleManager<O> createLifecycleManager();

    @Override
    public LifecycleState getLifecycleState() {
        return this.lifecycleManager.getState();
    }

    protected void disposeAndLogException() {
        try {
            this.dispose();
        }
        catch (Throwable t) {
            this.logger.error((Object)"Could not dispose of the message dispatcher!", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exceptionThrown(Exception e) {
        try {
            this.handleException(e);
        }
        finally {
            this.dispose();
        }
    }

    public void handleException(Exception exception) {
        this.connector.handleException(exception, this);
    }

    public boolean validate() {
        return !this.getLifecycleState().isDisposed();
    }

    public void activate() {
    }

    public void passivate() {
    }

    @Override
    public void initialise() throws InitialisationException {
        try {
            this.lifecycleManager.fireInitialisePhase(new LifecycleCallback<O>(){

                @Override
                public void onTransition(String phaseName, O object) throws MuleException {
                    AbstractConnectable.this.initializeRetryPolicy();
                    AbstractConnectable.this.initializeMessageFactory();
                    AbstractConnectable.this.doInitialise();
                }
            });
        }
        catch (InitialisationException e) {
            throw e;
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    protected void initializeRetryPolicy() {
        this.retryTemplate = this.endpoint.getRetryPolicyTemplate() != null ? this.endpoint.getRetryPolicyTemplate() : this.connector.getRetryPolicyTemplate();
    }

    protected void initializeMessageFactory() throws InitialisationException {
        try {
            this.muleMessageFactory = this.connector.getMuleMessageFactory();
        }
        catch (CreateException ce) {
            Message message = MessageFactory.createStaticMessage(ce.getMessage());
            throw new InitialisationException(message, (Throwable)ce, this);
        }
    }

    @Override
    public synchronized void dispose() {
        try {
            try {
                this.disconnect();
            }
            catch (Exception e) {
                this.logger.warn((Object)e.getMessage(), (Throwable)e);
            }
            if (this.isStarted()) {
                this.stop();
            }
            this.lifecycleManager.fireDisposePhase(new LifecycleCallback<O>(){

                @Override
                public void onTransition(String phaseName, O object) throws MuleException {
                    AbstractConnectable.this.doDispose();
                }
            });
        }
        catch (Exception e) {
            this.logger.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    public Connector getConnector() {
        return this.connector;
    }

    public ImmutableEndpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    public final synchronized void connect() throws Exception {
        if (this.connected.get() || this.connecting.get()) {
            return;
        }
        if (this.getLifecycleState().isDisposed()) {
            throw new IllegalStateException("Requester/dispatcher has been disposed; cannot connect to resource:" + this);
        }
        if (!this.connecting.compareAndSet(false, true)) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Connecting: " + this));
        }
        this.retryTemplate.execute(new RetryCallback(){

            public void doWork(RetryContext context) throws Exception {
                try {
                    AbstractConnectable.this.doConnect();
                    AbstractConnectable.this.connected.set(true);
                    AbstractConnectable.this.connecting.set(false);
                    if (AbstractConnectable.this.logger.isDebugEnabled()) {
                        AbstractConnectable.this.logger.debug((Object)("Connected: " + this.getWorkDescription()));
                    }
                    if (AbstractConnectable.this.startOnConnect) {
                        AbstractConnectable.this.start();
                    }
                }
                catch (Exception e) {
                    if (AbstractConnectable.this.logger.isDebugEnabled()) {
                        AbstractConnectable.this.logger.debug((Object)"exception in doWork", (Throwable)e);
                    }
                    throw e;
                }
            }

            public String getWorkDescription() {
                return AbstractConnectable.this.getConnectionDescription();
            }
        }, this.getWorkManager());
    }

    @Override
    public RetryContext validateConnection(RetryContext retryContext) {
        retryContext.setOk();
        return retryContext;
    }

    @Override
    public final synchronized void disconnect() throws Exception {
        if (!this.connected.get()) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Disconnecting: " + this));
        }
        this.doDisconnect();
        this.connected.set(false);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Disconnected: " + this));
        }
        this.connector.fireNotification(new ConnectionNotification(this, this.getConnectEventId(this.endpoint), 703));
    }

    protected String getConnectEventId(ImmutableEndpoint endpoint) {
        return this.connector.getName() + ".dispatcher(" + endpoint.getEndpointURI().getUri() + ")";
    }

    @Override
    public final boolean isConnected() {
        return this.connected.get();
    }

    public final boolean isConnecting() {
        return this.connecting.get();
    }

    protected boolean isDoThreading() {
        return this.connector.getDispatcherThreadingProfile().isDoThreading();
    }

    @Override
    public String getConnectionDescription() {
        return "endpoint.outbound." + this.endpoint.getEndpointURI().toString();
    }

    @Override
    public final void start() throws MuleException {
        if (!this.connected.get() && !this.connecting.get()) {
            this.connectAndThenStart();
        } else {
            try {
                this.retryTemplate.execute(new RetryCallback(){

                    public void doWork(RetryContext context) throws InterruptedException, MuleException {
                        AbstractConnectable.this.callDoStartWhenItIsConnected();
                    }

                    public String getWorkDescription() {
                        return "starting " + AbstractConnectable.this.getConnectionDescription();
                    }
                }, this.getWorkManager());
            }
            catch (MuleException e) {
                throw e;
            }
            catch (Exception e) {
                throw new StartException(CoreMessages.failedToStart("Connectable: " + this), (Throwable)e, this);
            }
        }
    }

    protected void connectAndThenStart() throws LifecycleException {
        this.startOnConnect = true;
        try {
            this.connect();
        }
        catch (Exception e) {
            throw new LifecycleException(e, (Object)this);
        }
    }

    protected void callDoStartWhenItIsConnected() throws InterruptedException, MuleException {
        try {
            this.connected.whenTrue(new Runnable(){

                public void run() {
                    try {
                        AbstractConnectable.this.lifecycleManager.fireStartPhase(new LifecycleCallback<O>(){

                            @Override
                            public void onTransition(String phaseName, O object) throws MuleException {
                                AbstractConnectable.this.doStart();
                            }
                        });
                    }
                    catch (MuleException e) {
                        throw new MuleRuntimeException(CoreMessages.createStaticMessage("wrapper exception for a MuleException"), (Throwable)e);
                    }
                }
            });
        }
        catch (MuleRuntimeException e) {
            if (e.getCause() instanceof MuleException) {
                throw (MuleException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public final void stop() throws MuleException {
        try {
            if (this.connected.get()) {
                this.disconnect();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.lifecycleManager.fireStopPhase(new LifecycleCallback<O>(){

            @Override
            public void onTransition(String phaseName, O object) throws MuleException {
                try {
                    AbstractConnectable.this.doStop();
                }
                catch (MuleException e) {
                    AbstractConnectable.this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    protected void doInitialise() throws InitialisationException {
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    protected void doStart() throws MuleException {
    }

    protected void doStop() throws MuleException {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(80);
        sb.append(ClassUtils.getSimpleName(this.getClass()));
        sb.append("{this=").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(", endpoint=").append(this.endpoint.getEndpointURI());
        sb.append(", disposed=").append(this.getLifecycleState().isDisposed());
        sb.append('}');
        return sb.toString();
    }

    public void setEndpoint(ImmutableEndpoint endpoint) {
        if (endpoint == null) {
            throw new IllegalArgumentException("Endpoint cannot be null");
        }
        this.endpoint = endpoint;
    }

    protected abstract WorkManager getWorkManager();

    public boolean isStarted() {
        return this.getLifecycleState().isStarted();
    }

    protected MuleMessageFactory createMuleMessageFactory() throws CreateException {
        return this.connector.createMuleMessageFactory();
    }

    public MuleMessage createMuleMessage(Object transportMessage, MuleMessage previousMessage, String encoding) throws MuleException {
        try {
            return this.muleMessageFactory.create(transportMessage, previousMessage, encoding);
        }
        catch (Exception e) {
            throw new CreateException(CoreMessages.failedToCreate("MuleMessage"), (Object)e);
        }
    }

    public MuleMessage createMuleMessage(Object transportMessage, String encoding) throws MuleException {
        try {
            return this.muleMessageFactory.create(transportMessage, encoding);
        }
        catch (Exception e) {
            throw new CreateException(CoreMessages.failedToCreate("MuleMessage"), (Object)e);
        }
    }

    public MuleMessage createMuleMessage(Object transportMessage) throws MuleException {
        String encoding = this.endpoint.getMuleContext().getConfiguration().getDefaultEncoding();
        return this.createMuleMessage(transportMessage, encoding);
    }

    protected MuleMessage createNullMuleMessage() throws MuleException {
        return this.createMuleMessage(null);
    }
}

