/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.context.MuleContextAware;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.PropertyScope;
import org.mule.transformer.AbstractMessageAwareTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.NullPayload;

public class MessagePropertiesTransformer
extends AbstractMessageAwareTransformer
implements MuleContextAware {
    private List deleteProperties = null;
    private Map addProperties = null;
    private Map renameProperties;
    private String getProperty;
    private boolean overwrite = true;
    private PropertyScope scope;
    private MuleContext muleContext;

    public MessagePropertiesTransformer() {
        this.registerSourceType(Object.class);
        this.setReturnDataType(DataTypeFactory.create(Object.class));
    }

    public Object clone() throws CloneNotSupportedException {
        MessagePropertiesTransformer clone = (MessagePropertiesTransformer)super.clone();
        if (this.deleteProperties != null) {
            clone.setDeleteProperties(new ArrayList(this.deleteProperties));
        }
        if (this.addProperties != null) {
            clone.setAddProperties(new HashMap(this.addProperties));
        }
        if (this.renameProperties != null) {
            clone.setRenameProperties(new HashMap(this.renameProperties));
        }
        return clone;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public Object transform(MuleMessage message, String outputEncoding) throws TransformerException {
        Object value;
        String key;
        if (this.deleteProperties != null && this.deleteProperties.size() > 0) {
            Iterator<Object> iterator = this.deleteProperties.iterator();
            while (iterator.hasNext()) {
                message.removeProperty(iterator.next().toString(), this.scope);
            }
        }
        if (this.addProperties != null && this.addProperties.size() > 0) {
            for (Map.Entry entry : this.addProperties.entrySet()) {
                if (entry.getKey() == null) {
                    this.logger.error((Object)"Setting Null property keys is not supported, this entry is being ignored");
                    continue;
                }
                key = entry.getKey().toString();
                value = entry.getValue();
                if (this.muleContext.getExpressionManager().isValidExpression(value.toString())) {
                    value = this.muleContext.getExpressionManager().evaluate(value.toString(), message);
                }
                if (message.getProperty(key, this.scope) != null) {
                    if (this.overwrite) {
                        this.logger.debug((Object)("Overwriting message property " + key));
                        message.setProperty(key, value, this.scope);
                        continue;
                    }
                    this.logger.debug((Object)MessageFormat.format("Message already contains the property and overwrite is false, skipping: key={0}, value={1}, scope={2}", key, value, this.scope));
                    continue;
                }
                message.setProperty(key, value, this.scope);
            }
        }
        if (this.renameProperties != null && this.renameProperties.size() > 0) {
            for (Map.Entry entry : this.renameProperties.entrySet()) {
                Object temp;
                if (entry.getKey() == null) {
                    this.logger.error((Object)"Setting Null property keys is not supported, this entry is being ignored");
                    continue;
                }
                key = entry.getKey().toString();
                value = (String)entry.getValue();
                if (value == null) {
                    this.logger.error((Object)"Setting Null property values for renameProperties is not supported, this entry is being ignored");
                    continue;
                }
                if (this.muleContext.getExpressionManager().isValidExpression((String)value) && (temp = this.muleContext.getExpressionManager().evaluate(((String)value).toString(), message)) != null) {
                    value = temp.toString();
                }
                if (this.logger.isDebugEnabled() && message.getProperty(key, this.scope) == null) {
                    this.logger.debug((Object)("renaming message property " + key + " to " + (String)value));
                }
                Object propValue = message.getProperty(key, this.scope);
                message.removeProperty(key, this.scope);
                message.setProperty((String)value, propValue, this.scope);
            }
        }
        if (this.getProperty != null) {
            Object prop = message.getProperty(this.getProperty, this.scope);
            message = prop != null ? new DefaultMuleMessage(prop, this.muleContext) : new DefaultMuleMessage(NullPayload.getInstance(), this.muleContext);
        }
        return message;
    }

    public List getDeleteProperties() {
        return this.deleteProperties;
    }

    public void setDeleteProperties(List deleteProperties) {
        this.deleteProperties = deleteProperties;
    }

    public Map getAddProperties() {
        return this.addProperties;
    }

    public void setAddProperties(Map addProperties) {
        this.addProperties = addProperties;
    }

    public Map getRenameProperties() {
        return this.renameProperties;
    }

    public void setRenameProperties(Map renameProperties) {
        this.renameProperties = renameProperties;
    }

    public String getGetProperty() {
        return this.getProperty;
    }

    public void setGetProperty(String getProperty) {
        this.getProperty = getProperty;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public PropertyScope getScope() {
        return this.scope;
    }

    public void setScope(PropertyScope scope) {
        this.scope = scope;
    }

    public String getScopeName() {
        return this.scope != null ? this.scope.getScopeName() : null;
    }

    public void setScopeName(String scopeName) {
        this.scope = PropertyScope.get(scopeName);
    }
}

