/*
 * Decompiled with CFR 0.152.
 */
package org.mule.session;

import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleSession;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.SessionHandler;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.codec.Base64Decoder;
import org.mule.transformer.codec.Base64Encoder;

public class LegacySessionHandler
implements SessionHandler {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private static Transformer encoder = new Base64Encoder();
    private static Transformer decoder = new Base64Decoder();

    public MuleSession retrieveSessionInfoFromMessage(MuleMessage message) throws MuleException {
        DefaultMuleSession session = new DefaultMuleSession(message.getMuleContext());
        String sessionId = (String)message.getProperty("MULE_SESSION_ID");
        message.removeProperty("MULE_SESSION_ID");
        Object sessionHeader = message.getProperty("MULE_SESSION");
        message.removeProperty("MULE_SESSION");
        if (sessionId != null) {
            throw new IllegalStateException("This session handler does not know how to look up session information for session id: " + sessionId);
        }
        if (sessionHeader != null) {
            String sessionString = null;
            try {
                sessionString = new String((byte[])decoder.transform(sessionHeader), message.getEncoding());
            }
            catch (UnsupportedEncodingException e) {
                sessionString = new String((byte[])decoder.transform(sessionHeader));
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Parsing session header: " + sessionString));
            }
            StringTokenizer stringTokenizer = new StringTokenizer(sessionString, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String pair = stringTokenizer.nextToken();
                int i = pair.indexOf("=");
                if (i == -1) {
                    throw new IllegalArgumentException(CoreMessages.sessionValueIsMalformed(pair).toString());
                }
                String name = pair.substring(0, i).trim();
                String value = pair.substring(i + 1).trim();
                session.setProperty(name, value);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Added MuleSession variable: " + pair));
            }
        }
        return session;
    }

    public void retrieveSessionInfoFromMessage(MuleMessage message, MuleSession session) throws MuleException {
        session = this.retrieveSessionInfoFromMessage(message);
    }

    public void storeSessionInfoToMessage(MuleSession session, MuleMessage message) throws MuleException {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getSessionIDKey()).append("=").append(session.getId());
        Iterator iterator = session.getPropertyNames();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            buf.append(";");
            buf.append(o).append("=").append(session.getProperty(o));
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Adding property to session header: " + o + "=" + session.getProperty(o)));
        }
        String sessionString = buf.toString();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Adding session header to message: " + sessionString));
        }
        sessionString = (String)encoder.transform(sessionString);
        message.setProperty("MULE_SESSION", sessionString);
    }

    public String getSessionIDKey() {
        return "ID";
    }
}

