/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service;

import java.beans.ExceptionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.component.Component;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleCallback;
import org.mule.api.lifecycle.LifecycleManager;
import org.mule.api.lifecycle.LifecycleState;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.model.Model;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.InboundRouterCollection;
import org.mule.api.routing.OutboundRouterCollection;
import org.mule.api.routing.ResponseRouterCollection;
import org.mule.api.service.Service;
import org.mule.api.source.MessageSource;
import org.mule.component.simple.PassThroughComponent;
import org.mule.config.i18n.CoreMessages;
import org.mule.lifecycle.EmptyLifecycleCallback;
import org.mule.lifecycle.processor.ProcessIfStartedWaitIfPausedMessageProcessor;
import org.mule.management.stats.ServiceStatistics;
import org.mule.processor.builder.InterceptingChainMessageProcessorBuilder;
import org.mule.routing.AbstractRouterCollection;
import org.mule.routing.inbound.DefaultInboundRouterCollection;
import org.mule.routing.outbound.DefaultOutboundRouterCollection;
import org.mule.routing.response.DefaultResponseRouterCollection;
import org.mule.service.ServiceLifecycleManager;
import org.mule.util.ClassUtils;

public abstract class AbstractService
implements Service {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected ServiceStatistics stats;
    protected Model model;
    protected MuleContext muleContext;
    protected ServiceLifecycleManager lifecycleManager;
    public static final String INITIAL_STATE_STOPPED = "stopped";
    public static final String INITIAL_STATE_STARTED = "started";
    public static final String INITIAL_STATE_PAUSED = "paused";
    protected ExceptionListener exceptionListener;
    protected String name;
    protected InboundRouterCollection inboundRouter = new DefaultInboundRouterCollection();
    protected OutboundRouterCollection outboundRouter = new DefaultOutboundRouterCollection();
    protected ResponseRouterCollection responseRouter = new DefaultResponseRouterCollection();
    protected MessageSource inboundMessageSource;
    protected MessageSource asyncReplyMessageSource;
    protected MessageProcessor messageProcessorChain;
    protected MessageProcessor serviceOnlyMessageProcessorChain;
    protected String initialState = "started";
    protected Component component = new PassThroughComponent();

    public AbstractService(MuleContext muleContext) {
        this.muleContext = muleContext;
        try {
            this.lifecycleManager = new ServiceLifecycleManager(this);
        }
        catch (MuleException e) {
            throw new MuleRuntimeException(CoreMessages.failedToCreate("Service Lifecycle Manager"), (Throwable)e);
        }
    }

    public final synchronized void initialise() throws InitialisationException {
        try {
            this.lifecycleManager.fireInitialisePhase(new LifecycleCallback<FlowConstruct>(){

                @Override
                public void onTransition(String phaseName, FlowConstruct object) throws MuleException {
                    ((MuleContextAware)((Object)AbstractService.this.outboundRouter)).setMuleContext(AbstractService.this.muleContext);
                    if (AbstractService.this.exceptionListener == null) {
                        AbstractService.this.exceptionListener = AbstractService.this.getModel().getExceptionListener();
                    }
                    AbstractService.this.inboundMessageSource = ((DefaultInboundRouterCollection)AbstractService.this.inboundRouter).getMessageSource();
                    AbstractService.this.asyncReplyMessageSource = ((DefaultInboundRouterCollection)((Object)AbstractService.this.responseRouter)).getMessageSource();
                    if (AbstractService.this.inboundMessageSource instanceof FlowConstructAware) {
                        ((FlowConstructAware)((Object)AbstractService.this.inboundMessageSource)).setFlowConstruct(object);
                    }
                    if (AbstractService.this.asyncReplyMessageSource instanceof FlowConstructAware) {
                        ((FlowConstructAware)((Object)AbstractService.this.asyncReplyMessageSource)).setFlowConstruct(object);
                    }
                    AbstractService.this.component.setFlowConstruct(object);
                    AbstractService.this.doInitialise();
                }
            });
        }
        catch (InitialisationException e) {
            throw e;
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public void start() throws MuleException {
        if (!this.isStopped() && this.initialState.equals(INITIAL_STATE_STOPPED)) {
            this.lifecycleManager.fireStartPhase((LifecycleCallback<FlowConstruct>)new EmptyLifecycleCallback<FlowConstruct>());
            this.lifecycleManager.fireStopPhase((LifecycleCallback<FlowConstruct>)new EmptyLifecycleCallback<FlowConstruct>());
            this.logger.info((Object)("Service " + this.name + " has not been started (initial state = 'stopped')"));
            return;
        }
        this.lifecycleManager.fireStartPhase(new LifecycleCallback<FlowConstruct>(){

            @Override
            public void onTransition(String phaseName, FlowConstruct object) throws MuleException {
                AbstractService.this.doStart();
            }
        });
        if (this.initialState.equals(INITIAL_STATE_PAUSED)) {
            this.pause();
            this.logger.info((Object)("Service " + this.name + " has been started and paused (initial state = 'paused')"));
        }
    }

    public final void pause() throws MuleException {
        this.lifecycleManager.firePausePhase(new LifecycleCallback<FlowConstruct>(){

            @Override
            public void onTransition(String phaseName, FlowConstruct object) throws MuleException {
                AbstractService.this.doPause();
            }
        });
    }

    public final void resume() throws MuleException {
        this.lifecycleManager.fireResumePhase(new LifecycleCallback<FlowConstruct>(){

            @Override
            public void onTransition(String phaseName, FlowConstruct object) throws MuleException {
                AbstractService.this.doResume();
            }
        });
    }

    public void stop() throws MuleException {
        this.lifecycleManager.fireStopPhase(new LifecycleCallback<FlowConstruct>(){

            @Override
            public void onTransition(String phaseName, FlowConstruct object) throws MuleException {
                AbstractService.this.doStop();
            }
        });
    }

    public final void dispose() {
        try {
            if (this.isStarted()) {
                this.stop();
            }
            this.lifecycleManager.fireDisposePhase(new LifecycleCallback<FlowConstruct>(){

                @Override
                public void onTransition(String phaseName, FlowConstruct object) throws MuleException {
                    AbstractService.this.doDispose();
                }
            });
        }
        catch (MuleException e) {
            this.logger.error((Object)("Failed to stop service: " + this.name), (Throwable)e);
        }
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleManager.getState();
    }

    public boolean isStarted() {
        return this.lifecycleManager.getState().isStarted();
    }

    public boolean isPaused() {
        return this.lifecycleManager.getCurrentPhase().equals("pause");
    }

    public boolean isStopped() {
        return this.lifecycleManager.getState().isStopped();
    }

    public boolean isStopping() {
        return this.lifecycleManager.getState().isStopping();
    }

    protected void doPause() throws MuleException {
    }

    protected void doResume() throws MuleException {
    }

    protected void doForceStop() throws MuleException {
    }

    protected void doStop() throws MuleException {
        if (this.inboundMessageSource instanceof Stoppable) {
            ((Stoppable)((Object)this.inboundMessageSource)).stop();
        }
        if (this.asyncReplyMessageSource instanceof Stoppable) {
            ((Stoppable)((Object)this.asyncReplyMessageSource)).stop();
        }
        if (this.component instanceof Stoppable) {
            ((Stoppable)((Object)this.component)).stop();
        }
        if (this.messageProcessorChain instanceof Stoppable) {
            ((Stoppable)((Object)this.messageProcessorChain)).stop();
        }
    }

    protected void doStart() throws MuleException {
        if (this.component instanceof Startable) {
            ((Startable)((Object)this.component)).start();
        }
        if (this.messageProcessorChain instanceof Startable) {
            ((Startable)((Object)this.messageProcessorChain)).start();
        }
        if (this.inboundMessageSource instanceof Startable) {
            ((Startable)((Object)this.inboundMessageSource)).start();
        }
        if (this.asyncReplyMessageSource instanceof Startable) {
            ((Startable)((Object)this.asyncReplyMessageSource)).start();
        }
    }

    protected void doDispose() {
        if (this.component instanceof Disposable) {
            ((Disposable)((Object)this.component)).dispose();
        }
        if (this.messageProcessorChain instanceof Disposable) {
            ((Disposable)((Object)this.messageProcessorChain)).dispose();
        }
        this.responseRouter.dispose();
        this.inboundRouter.dispose();
        this.muleContext.getStatistics().remove(this.stats);
    }

    protected void doInitialise() throws InitialisationException {
        this.stats = this.createStatistics();
        this.stats.setEnabled(this.muleContext.getStatistics().isEnabled());
        this.muleContext.getStatistics().add(this.stats);
        if (this.outboundRouter != null) {
            this.stats.setOutboundRouterStat(this.outboundRouter.getStatistics());
        }
        this.stats.setInboundRouterStat(this.inboundRouter.getStatistics());
        this.stats.setComponentStat(this.component.getStatistics());
        this.buildServiceMessageProcessorChain();
        this.inboundMessageSource.setListener(this.messageProcessorChain);
        this.asyncReplyMessageSource.setListener(this.getResponseRouter());
        if (this.component instanceof Initialisable) {
            ((Initialisable)((Object)this.component)).initialise();
        }
        if (this.messageProcessorChain instanceof Initialisable) {
            ((Initialisable)((Object)this.messageProcessorChain)).initialise();
        }
        ((AbstractRouterCollection)((Object)this.responseRouter)).setMuleContext(this.muleContext);
        this.responseRouter.initialise();
        ((AbstractRouterCollection)((Object)this.inboundRouter)).setMuleContext(this.muleContext);
        this.inboundRouter.initialise();
    }

    public void forceStop() throws MuleException {
        this.doForceStop();
        this.stop();
    }

    protected void handleException(Exception e) {
        this.exceptionListener.exceptionThrown(e);
    }

    protected void buildServiceMessageProcessorChain() {
        InterceptingChainMessageProcessorBuilder builder = new InterceptingChainMessageProcessorBuilder();
        builder.setName("Service '" + this.name + "' Processor Chain");
        builder.chain(this.getServiceStartedAssertingMessageProcessor());
        this.addMessageProcessors(builder);
        this.serviceOnlyMessageProcessorChain = builder.build();
        builder.chainBefore(this.inboundRouter);
        this.messageProcessorChain = builder.build();
        if (this.messageProcessorChain instanceof FlowConstructAware) {
            ((FlowConstructAware)((Object)this.messageProcessorChain)).setFlowConstruct(this);
        }
    }

    protected MessageProcessor getServiceStartedAssertingMessageProcessor() {
        return new ProcessIfStartedWaitIfPausedMessageProcessor(this, this.lifecycleManager.getState());
    }

    protected abstract void addMessageProcessors(InterceptingChainMessageProcessorBuilder var1);

    protected ServiceStatistics createStatistics() {
        return new ServiceStatistics(this.name);
    }

    public ServiceStatistics getStatistics() {
        return this.stats;
    }

    @Deprecated
    public void dispatchEvent(MuleEvent event) throws MuleException {
        this.serviceOnlyMessageProcessorChain.process(event);
    }

    @Deprecated
    public MuleMessage sendEvent(MuleEvent event) throws MuleException {
        MuleEvent resultEvent = this.serviceOnlyMessageProcessorChain.process(event);
        if (resultEvent != null) {
            return resultEvent.getMessage();
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return String.format("%s{%s}", ClassUtils.getSimpleName(this.getClass()), this.getName());
    }

    public Model getModel() {
        return this.model;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public InboundRouterCollection getInboundRouter() {
        return this.inboundRouter;
    }

    public void setInboundRouter(InboundRouterCollection inboundRouter) {
        this.inboundRouter = inboundRouter;
    }

    public OutboundRouterCollection getOutboundRouter() {
        return this.outboundRouter;
    }

    public void setOutboundRouter(OutboundRouterCollection outboundRouter) {
        this.outboundRouter = outboundRouter;
    }

    public ResponseRouterCollection getResponseRouter() {
        return this.responseRouter;
    }

    public void setResponseRouter(ResponseRouterCollection responseRouter) {
        this.responseRouter = responseRouter;
    }

    public String getInitialState() {
        return this.initialState;
    }

    public void setInitialState(String initialState) {
        this.initialState = initialState;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
        this.component.setFlowConstruct(this);
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public LifecycleManager getLifecycleManager() {
        return this.lifecycleManager;
    }
}

