/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.response;

import org.mule.OptimizedRequestContext;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.routing.ResponseRouter;
import org.mule.api.routing.ResponseRouterCollection;
import org.mule.api.routing.Router;
import org.mule.api.routing.RoutingException;
import org.mule.management.stats.RouterStatistics;
import org.mule.routing.inbound.DefaultInboundRouterCollection;

public class DefaultResponseRouterCollection
extends DefaultInboundRouterCollection
implements ResponseRouterCollection {
    private volatile int timeout = -1;
    private volatile boolean failOnTimeout = true;

    public DefaultResponseRouterCollection() {
        this.statistics = new RouterStatistics(3);
    }

    public void initialise() throws InitialisationException {
        if (this.timeout == -1) {
            this.setTimeout(this.muleContext.getConfiguration().getDefaultResponseTimeout());
        }
        super.initialise();
    }

    public MuleEvent process(MuleEvent event) throws MessagingException {
        for (ResponseRouter responseRouter : this.getRouters()) {
            responseRouter.process(event);
            if (!this.getStatistics().isEnabled()) continue;
            this.getStatistics().incrementRoutedMessage(event.getEndpoint());
        }
        return null;
    }

    public MuleEvent getResponse(MuleEvent message) throws RoutingException {
        MuleEvent result = null;
        if (this.routers.size() == 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"There are no routers configured on the response router. Returning the current message");
            }
        } else {
            for (ResponseRouter responseRouter : this.getRouters()) {
                result = responseRouter.getResponse(message);
            }
            if (result == null && this.getStatistics().isEnabled()) {
                this.getStatistics().incrementNoRoutedMessage();
            }
            return OptimizedRequestContext.criticalSetEvent(result);
        }
        result = message;
        return result;
    }

    public void addRouter(Router router) {
        ((ResponseRouter)router).setTimeout(this.getTimeout());
        ((ResponseRouter)router).setFailOnTimeout(this.isFailOnTimeout());
        this.routers.add(router);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean isFailOnTimeout() {
        return this.failOnTimeout;
    }

    public void setFailOnTimeout(boolean failOnTimeout) {
        this.failOnTimeout = failOnTimeout;
    }

    public boolean hasEndpoints() {
        return !this.getEndpoints().isEmpty();
    }
}

