/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.EndpointNotFoundException;
import org.mule.api.endpoint.MalformedEndpointException;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.api.routing.CouldNotRouteOutboundMessageException;
import org.mule.api.routing.RoutingException;
import org.mule.config.i18n.CoreMessages;
import org.mule.expression.ExpressionConfig;
import org.mule.routing.outbound.FilteringOutboundRouter;
import org.mule.util.StringUtils;

public class EndpointSelector
extends FilteringOutboundRouter {
    public static final String DEFAULT_SELECTOR_EVALUATOR = "header";
    public static final String DEFAULT_SELECTOR_EXPRESSION = "endpoint";
    private String defaultEndpointName;
    private ExpressionConfig expressionConfig = new ExpressionConfig("endpoint", "header", null);

    public MuleEvent route(MuleEvent event) throws RoutingException {
        List endpoints;
        MuleMessage message = event.getMessage();
        MuleSession session = event.getSession();
        String prop = this.expressionConfig.getFullExpression(this.expressionManager);
        if (!this.muleContext.getExpressionManager().isValidExpression(prop)) {
            throw new CouldNotRouteOutboundMessageException(CoreMessages.expressionInvalidForProperty("expression", prop), message, null);
        }
        Object property = null;
        try {
            property = this.muleContext.getExpressionManager().evaluate(prop, message);
        }
        catch (ExpressionRuntimeException e) {
            this.logger.error((Object)e.getMessage());
        }
        if (property == null && this.getDefaultEndpointName() == null) {
            throw new CouldNotRouteOutboundMessageException(CoreMessages.expressionResultWasNull(this.expressionConfig.getFullExpression(this.expressionManager)), message, null);
        }
        if (property == null) {
            this.logger.info((Object)("Expression: " + prop + " returned null, using default endpoint: " + this.getDefaultEndpointName()));
            property = this.getDefaultEndpointName();
        }
        if (property instanceof String) {
            endpoints = new ArrayList<Object>(1);
            endpoints.add(property);
        } else if (property instanceof List) {
            endpoints = (List)property;
        } else {
            throw new CouldNotRouteOutboundMessageException(CoreMessages.propertyIsNotSupportedType(this.expressionConfig.getFullExpression(this.expressionManager), new Class[]{String.class, List.class}, property.getClass()), message, null);
        }
        ArrayList<MuleMessage> results = new ArrayList<MuleMessage>(endpoints.size());
        Iterator iterator = endpoints.iterator();
        while (iterator.hasNext()) {
            String endpointName = iterator.next().toString();
            if (StringUtils.isEmpty((String)endpointName)) {
                throw new CouldNotRouteOutboundMessageException(CoreMessages.objectIsNull("Endpoint Name: " + this.expressionConfig.getFullExpression(this.expressionManager)), message, null);
            }
            OutboundEndpoint ep = null;
            try {
                ep = this.lookupEndpoint(endpointName);
                if (ep == null) {
                    throw new CouldNotRouteOutboundMessageException(CoreMessages.objectNotFound("Endpoint", endpointName), message, ep);
                }
                if (ep.isSynchronous()) {
                    results.add(this.getMessage(this.sendRequest(session, message, ep, true)));
                    continue;
                }
                this.sendRequest(session, message, ep, false);
            }
            catch (MuleException e) {
                throw new CouldNotRouteOutboundMessageException(message, ep, (Throwable)e);
            }
        }
        return this.createEvent(this.resultsHandler.aggregateResults(results, message, this.muleContext), event);
    }

    protected OutboundEndpoint lookupEndpoint(String endpointName) throws MuleException {
        for (OutboundEndpoint ep : this.endpoints) {
            if (endpointName.equals(ep.getName())) {
                return ep;
            }
            if (endpointName.equals(ep.getName())) {
                return ep;
            }
            if (!endpointName.equals(ep.getEndpointURI().getUri().toString())) continue;
            return ep;
        }
        try {
            return this.getMuleContext().getRegistry().lookupEndpointFactory().getOutboundEndpoint(endpointName);
        }
        catch (MalformedEndpointException e) {
            throw new EndpointNotFoundException(CoreMessages.endpointNotFound(endpointName), (Throwable)e);
        }
    }

    public String getExpression() {
        return this.expressionConfig.getExpression();
    }

    public void setExpression(String expression) {
        this.expressionConfig.setExpression(expression);
    }

    public String getCustomEvaluator() {
        return this.expressionConfig.getCustomEvaluator();
    }

    public void setCustomEvaluator(String customEvaluator) {
        this.expressionConfig.setCustomEvaluator(customEvaluator);
    }

    public String getEvaluator() {
        return this.expressionConfig.getEvaluator();
    }

    public void setEvaluator(String evaluator) {
        this.expressionConfig.setEvaluator(evaluator);
    }

    public String getDefaultEndpointName() {
        return this.defaultEndpointName;
    }

    public void setDefaultEndpointName(String defaultEndpointName) {
        this.defaultEndpointName = defaultEndpointName;
    }
}

