/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.Iterator;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.routing.OutboundRouter;
import org.mule.api.routing.OutboundRouterCollection;
import org.mule.api.routing.Router;
import org.mule.api.routing.RoutingException;
import org.mule.api.transaction.TransactionCallback;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.AbstractRouterCollection;
import org.mule.transaction.TransactionTemplate;

public class DefaultOutboundRouterCollection
extends AbstractRouterCollection
implements OutboundRouterCollection {
    public DefaultOutboundRouterCollection() {
        super(2);
    }

    public MuleEvent process(final MuleEvent event) throws MessagingException {
        MuleMessage message = event.getMessage();
        MuleSession session = event.getSession();
        boolean matchfound = false;
        Iterator<Router> iterator = this.getRouters().iterator();
        while (iterator.hasNext()) {
            MuleEvent result;
            MuleMessage outboundRouterMessage;
            OutboundRouter outboundRouter = (OutboundRouter)iterator.next();
            if (iterator.hasNext() && (this.isMatchAll() || outboundRouter.isRequiresNewMessage())) {
                if (((DefaultMuleMessage)message).isConsumable()) {
                    throw new MessagingException(CoreMessages.cannotCopyStreamPayload(message.getPayload().getClass().getName()), message);
                }
                outboundRouterMessage = new DefaultMuleMessage(message.getPayload(), message, this.muleContext);
            } else {
                outboundRouterMessage = message;
            }
            if (!outboundRouter.isMatch(outboundRouterMessage)) continue;
            matchfound = true;
            final OutboundRouter router = outboundRouter;
            TransactionTemplate tt = new TransactionTemplate(outboundRouter.getTransactionConfig(), event.getFlowConstruct().getExceptionListener(), this.muleContext);
            TransactionCallback cb = new TransactionCallback(){

                public Object doInTransaction() throws Exception {
                    return router.process(event);
                }
            };
            try {
                result = (MuleEvent)tt.execute(cb);
            }
            catch (Exception e) {
                throw new RoutingException(outboundRouterMessage, null, (Throwable)e);
            }
            if (this.isMatchAll()) continue;
            return result;
        }
        if (!matchfound && this.getCatchAllStrategy() != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Message did not match any routers on: " + session.getFlowConstruct().getName() + " invoking catch all strategy"));
            }
            return this.catchAll(event);
        }
        if (!matchfound) {
            this.logger.warn((Object)("Message did not match any routers on: " + session.getFlowConstruct().getName() + " and there is no catch all strategy configured on this router.  Disposing message " + message));
        }
        return event;
    }

    protected MuleEvent catchAll(MuleEvent event) throws RoutingException {
        if (this.getStatistics().isEnabled()) {
            this.getStatistics().incrementCaughtMessage();
        }
        return this.getCatchAllStrategy().process(event);
    }

    public boolean hasEndpoints() {
        for (OutboundRouter router : this.routers) {
            if (router.getEndpoints().size() <= 0 && !router.isDynamicEndpoints()) continue;
            return true;
        }
        return false;
    }
}

