/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.inbound;

import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.ResettableIterator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang.SerializationException;
import org.apache.commons.lang.SerializationUtils;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.routing.AggregationException;
import org.mule.routing.CollectionCorrelatorCallback;
import org.mule.routing.EventCorrelatorCallback;
import org.mule.routing.inbound.AbstractEventAggregator;
import org.mule.routing.inbound.CorrelationSequenceComparator;
import org.mule.routing.inbound.EventGroup;

public class MessageChunkingAggregator
extends AbstractEventAggregator {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    protected Comparator eventComparator = new CorrelationSequenceComparator();

    protected EventCorrelatorCallback getCorrelatorCallback() {
        return new CollectionCorrelatorCallback(this.muleContext){

            public MuleMessage aggregateEvents(EventGroup events) throws AggregationException {
                Object[] collectedEvents = events.toArray();
                MuleEvent firstEvent = collectedEvents[0];
                Arrays.sort(collectedEvents, MessageChunkingAggregator.this.eventComparator);
                ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
                try {
                    DefaultMuleMessage message;
                    ResettableIterator iterator = IteratorUtils.arrayIterator((Object[])collectedEvents);
                    while (iterator.hasNext()) {
                        MuleEvent event = (MuleEvent)iterator.next();
                        baos.write(event.getMessageAsBytes());
                    }
                    try {
                        message = new DefaultMuleMessage(SerializationUtils.deserialize((byte[])baos.toByteArray()), firstEvent.getMessage(), this.muleContext);
                    }
                    catch (SerializationException e) {
                        message = new DefaultMuleMessage((Object)baos.toByteArray(), firstEvent.getMessage(), this.muleContext);
                    }
                    message.setCorrelationGroupSize(-1);
                    message.setCorrelationSequence(-1);
                    DefaultMuleMessage defaultMuleMessage = message;
                    return defaultMuleMessage;
                }
                catch (Exception e) {
                    throw new AggregationException(events, firstEvent.getEndpoint(), (Throwable)e);
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)baos);
                }
            }
        };
    }
}

