/*
 * Decompiled with CFR 0.152.
 */
package org.mule.registry;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.mule.api.registry.InjectProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.annotation.AnnotationMetaData;
import org.mule.util.annotation.AnnotationUtils;

public class JSR250ValidatorProcessor
implements InjectProcessor {
    public Object process(Object object) {
        List<AnnotationMetaData> annos = AnnotationUtils.getMethodAnnotations(object.getClass(), PostConstruct.class);
        if (annos.size() > 1) {
            throw new IllegalArgumentException(CoreMessages.objectHasMoreThanOnePostConstructAnnotation(object.getClass()).getMessage());
        }
        if (annos.size() == 1) {
            this.validateLifecycleMethod((Method)annos.get(0).getMember());
        }
        if ((annos = AnnotationUtils.getMethodAnnotations(object.getClass(), PreDestroy.class)).size() > 1) {
            throw new IllegalArgumentException(CoreMessages.objectHasMoreThanOnePreDestroyAnnotation(object.getClass()).getMessage());
        }
        if (annos.size() == 1) {
            this.validateLifecycleMethod((Method)annos.get(0).getMember());
        }
        return object;
    }

    public final void validateLifecycleMethod(Method method) {
        if (method.getParameterTypes().length != 0) {
            throw new IllegalArgumentException(CoreMessages.lifecycleMethodNotVoidOrHasParams(method).getMessage());
        }
        if (!method.getReturnType().equals(Void.TYPE)) {
            throw new IllegalArgumentException(CoreMessages.lifecycleMethodNotVoidOrHasParams(method).getMessage());
        }
        if (Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException(CoreMessages.lifecycleMethodCannotBeStatic(method).getMessage());
        }
        for (Class<?> aClass : method.getExceptionTypes()) {
            if (RuntimeException.class.isAssignableFrom(aClass)) continue;
            throw new IllegalArgumentException(CoreMessages.lifecycleMethodCannotThrowChecked(method).getMessage());
        }
    }
}

