/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorBuilder;
import org.mule.processor.NullMessageProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IteratingListMessageProcessorBuilder
implements MessageProcessorBuilder {
    protected List<MessageProcessor> list = new ArrayList<MessageProcessor>();
    protected String name;

    @Override
    public MessageProcessor build() {
        if (this.list.isEmpty()) {
            return new NullMessageProcessor();
        }
        return new IteratingListCompositeMessageProcessor(this.list, this.name);
    }

    public void setName(String name) {
        this.name = name;
    }

    public IteratingListMessageProcessorBuilder add(MessageProcessor ... processors) {
        for (MessageProcessor messageProcessor : processors) {
            this.list.add(messageProcessor);
        }
        return this;
    }

    public IteratingListMessageProcessorBuilder InterceptingChainMessageProcessorBuilder(Collection<MessageProcessor> processors) {
        if (processors != null) {
            this.list.addAll(processors);
        }
        return this;
    }

    public IteratingListMessageProcessorBuilder addBefore(MessageProcessor processor) {
        this.list.add(0, processor);
        return this;
    }

    public String toString() {
        if (this.name != null) {
            return "IteratingListMessageProcessorBuilder '" + this.name + "'";
        }
        return super.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IteratingListCompositeMessageProcessor
    implements MessageProcessor,
    Lifecycle,
    FlowConstructAware {
        private Log log;
        private String name;
        private List<MessageProcessor> list;

        public IteratingListCompositeMessageProcessor(List<MessageProcessor> list, String name) {
            this.name = name;
            this.list = list;
            this.log = LogFactory.getLog(IteratingListCompositeMessageProcessor.class);
        }

        @Override
        public MuleEvent process(MuleEvent event) throws MuleException {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Invoking " + this + " with event " + event));
            }
            MuleEvent result = event;
            for (MessageProcessor processor : this.list) {
                result = processor.process(result);
            }
            return result;
        }

        @Override
        public void initialise() throws InitialisationException {
            for (MessageProcessor processor : this.list) {
                if (!(processor instanceof Initialisable)) continue;
                ((Initialisable)((Object)processor)).initialise();
            }
        }

        @Override
        public void start() throws MuleException {
            for (MessageProcessor processor : this.list) {
                if (!(processor instanceof Startable)) continue;
                ((Startable)((Object)processor)).start();
            }
        }

        @Override
        public void stop() throws MuleException {
            for (MessageProcessor processor : this.list) {
                if (!(processor instanceof Stoppable)) continue;
                ((Stoppable)((Object)processor)).stop();
            }
        }

        @Override
        public void dispose() {
            for (MessageProcessor processor : this.list) {
                if (!(processor instanceof Disposable)) continue;
                ((Disposable)((Object)processor)).dispose();
            }
        }

        @Override
        public void setFlowConstruct(FlowConstruct flowConstruct) {
            for (MessageProcessor processor : this.list) {
                if (!(processor instanceof FlowConstructAware)) continue;
                ((FlowConstructAware)((Object)processor)).setFlowConstruct(flowConstruct);
            }
        }

        public String toString() {
            StringBuffer string = new StringBuffer();
            string.append("IteratingListCompositeMessageProcessor ");
            if (this.name != null) {
                string.append(" '" + this.name + "' ");
            } else {
                string.append("[ processors= ");
                Iterator<MessageProcessor> mpIterator = this.list.iterator();
                while (mpIterator.hasNext()) {
                    MessageProcessor mp = mpIterator.next();
                    string.append(mp.getClass().getName());
                    if (!mpIterator.hasNext()) continue;
                    string.append(", ");
                }
                string.append(" ]");
            }
            return string.toString();
        }
    }
}

