/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import java.beans.ExceptionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.transaction.TransactionCallback;
import org.mule.api.transaction.TransactionConfig;
import org.mule.config.i18n.CoreMessages;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.transaction.TransactionTemplate;

public class TransactionalInterceptingMessageProcessor
extends AbstractInterceptingMessageProcessor {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected TransactionConfig transactionConfig;
    protected ExceptionListener exceptionListener;

    public TransactionalInterceptingMessageProcessor(TransactionConfig transactionConfig, ExceptionListener exceptionListener) {
        this.transactionConfig = transactionConfig;
        this.exceptionListener = exceptionListener;
    }

    public MuleEvent process(final MuleEvent event) throws MuleException {
        if (this.next == null) {
            return event;
        }
        TransactionTemplate tt = new TransactionTemplate(this.transactionConfig, this.exceptionListener, event.getMuleContext());
        TransactionCallback cb = new TransactionCallback(){

            public Object doInTransaction() throws Exception {
                return TransactionalInterceptingMessageProcessor.this.next.process(event);
            }
        };
        try {
            return (MuleEvent)tt.execute(cb);
        }
        catch (MessagingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessagingException(CoreMessages.errorInvokingMessageProcessorWithinTransaction(this.next, this.transactionConfig), event.getMessage(), e);
        }
    }
}

