/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import java.beans.ExceptionListener;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkListener;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.context.WorkManagerSource;
import org.mule.config.i18n.CoreMessages;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.work.AbstractMuleEventWork;

public class AsyncInterceptingMessageProcessor
extends AbstractInterceptingMessageProcessor
implements WorkListener {
    protected WorkManagerSource workManagerSource;
    protected ExceptionListener exceptionListener;
    protected boolean doThreading;

    public AsyncInterceptingMessageProcessor(WorkManagerSource workManagerSource, boolean doThreading, ExceptionListener exceptionListener) {
        this.workManagerSource = workManagerSource;
        this.exceptionListener = exceptionListener;
        this.doThreading = doThreading;
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        if (this.next == null) {
            return event;
        }
        if (event.getEndpoint().isSynchronous() || event.getEndpoint().getTransactionConfig().isTransacted()) {
            return this.processNext(event);
        }
        this.processAsync(event);
        return null;
    }

    protected void processAsync(MuleEvent event) throws MuleException {
        try {
            AsyncMessageProcessorWoker work = new AsyncMessageProcessorWoker(event);
            if (this.doThreading) {
                this.workManagerSource.getWorkManager().scheduleWork(work, Long.MAX_VALUE, null, this);
            } else {
                work.run();
            }
        }
        catch (Exception e) {
            new MessagingException(CoreMessages.errorSchedulingMessageProcessorForAsyncInvocation(this.next), event.getMessage(), e);
        }
    }

    public void workAccepted(WorkEvent event) {
        this.handleWorkException(event, "workAccepted");
    }

    public void workRejected(WorkEvent event) {
        this.handleWorkException(event, "workRejected");
    }

    public void workStarted(WorkEvent event) {
        this.handleWorkException(event, "workStarted");
    }

    public void workCompleted(WorkEvent event) {
        this.handleWorkException(event, "workCompleted");
    }

    protected void handleWorkException(WorkEvent event, String type) {
        if (event == null) {
            return;
        }
        Throwable e = event.getException();
        if (e == null) {
            return;
        }
        if (e.getCause() != null) {
            e = e.getCause();
        }
        this.logger.error((Object)("Work caused exception on '" + type + "'. Work being executed was: " + event.getWork().toString()));
        if (!(e instanceof Exception)) {
            throw new MuleRuntimeException(CoreMessages.errorInvokingMessageProcessorAsynchronously(this.next), e);
        }
        this.exceptionListener.exceptionThrown((Exception)e);
    }

    class AsyncMessageProcessorWoker
    extends AbstractMuleEventWork {
        public AsyncMessageProcessorWoker(MuleEvent event) {
            super(event);
        }

        protected void doRun() {
            try {
                AsyncInterceptingMessageProcessor.this.processNext(this.event);
            }
            catch (MuleException e) {
                AsyncInterceptingMessageProcessor.this.exceptionListener.exceptionThrown(e);
            }
        }
    }
}

