/*
 * Decompiled with CFR 0.152.
 */
package org.mule.model.seda;

import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.context.WorkManager;
import org.mule.api.context.WorkManagerSource;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.ChainedThreadingProfile;
import org.mule.config.QueueProfile;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.lifecycle.processor.ProcessIfStartedWaitIfSyncPausedMessageProcessor;
import org.mule.management.stats.ServiceStatistics;
import org.mule.model.seda.SedaModel;
import org.mule.processor.SedaStageInterceptingMessageProcessor;
import org.mule.processor.builder.InterceptingChainMessageProcessorBuilder;
import org.mule.service.AbstractService;
import org.mule.service.processor.ServiceInternalMessageProcessor;
import org.mule.service.processor.ServiceLoggingMessageObserver;
import org.mule.service.processor.ServiceOutboundMessageProcessor;
import org.mule.service.processor.ServiceOutboundStatisticsObserver;
import org.mule.service.processor.ServiceSetEventRequestContextMessageObserver;
import org.mule.service.processor.ServiceStatisticsMessageObserver;

public class SedaService
extends AbstractService {
    private static final long serialVersionUID = 7711976708670893015L;
    protected Integer queueTimeout;
    protected ThreadingProfile threadingProfile;
    protected QueueProfile queueProfile;
    protected WorkManager workManager;

    public SedaService(MuleContext muleContext) {
        super(muleContext);
    }

    protected MessageProcessor getServiceStartedAssertingMessageProcessor() {
        return new ProcessIfStartedWaitIfSyncPausedMessageProcessor(this, this.lifecycleManager.getState());
    }

    protected void addMessageProcessors(InterceptingChainMessageProcessorBuilder builder) {
        builder.chain(new ServiceLoggingMessageObserver(this));
        builder.chain(new ServiceStatisticsMessageObserver(this));
        builder.chain(new ServiceSetEventRequestContextMessageObserver());
        builder.chain(new SedaStageInterceptingMessageProcessor(this.getName(), this.queueProfile, this.queueTimeout, new WorkManagerSource(){

            public WorkManager getWorkManager() throws MuleException {
                return SedaService.this.workManager;
            }
        }, this.getThreadingProfile().isDoThreading(), this.lifecycleManager.getState(), this.exceptionListener, this.stats, this.muleContext));
        builder.chain(new ServiceInternalMessageProcessor(this));
        builder.chain(new ServiceOutboundMessageProcessor(this));
        builder.chain(new ServiceOutboundStatisticsObserver(this));
        builder.chain(this.outboundRouter);
    }

    protected synchronized void doInitialise() throws InitialisationException {
        if (this.threadingProfile == null) {
            this.threadingProfile = this.muleContext.getDefaultServiceThreadingProfile();
        }
        ChainedThreadingProfile threadingProfile = new ChainedThreadingProfile(this.threadingProfile);
        threadingProfile.setMuleContext(this.muleContext);
        threadingProfile.setMaxThreadsActive(threadingProfile.getMaxThreadsActive() + 1);
        this.workManager = threadingProfile.createWorkManager(this.getName(), this.muleContext.getConfiguration().getShutdownTimeout());
        if (this.queueProfile == null) {
            this.queueProfile = ((SedaModel)this.model).getQueueProfile();
        }
        if (this.queueTimeout == null) {
            this.setQueueTimeout(((SedaModel)this.model).getQueueTimeout());
        }
        try {
            if (this.name == null) {
                throw new InitialisationException(MessageFactory.createStaticMessage("Service has no name to identify it"), (Initialisable)this);
            }
        }
        catch (Throwable e) {
            throw new InitialisationException(CoreMessages.objectFailedToInitialise("Service Queue"), e, this);
        }
        super.doInitialise();
    }

    protected void doStart() throws MuleException {
        try {
            this.workManager.start();
        }
        catch (Exception e) {
            throw new LifecycleException(CoreMessages.failedToStart("Service: " + this.getName()), e, this);
        }
        super.doStart();
    }

    protected void doStop() throws MuleException {
        super.doStop();
        this.workManager.dispose();
    }

    protected void doForceStop() throws MuleException {
        this.doStop();
    }

    protected void doDispose() {
        super.doDispose();
        if (this.workManager != null) {
            this.workManager.dispose();
        }
    }

    protected ServiceStatistics createStatistics() {
        return new ServiceStatistics(this.getName(), this.threadingProfile.getMaxThreadsActive());
    }

    public QueueProfile getQueueProfile() {
        return this.queueProfile;
    }

    public void setQueueProfile(QueueProfile queueProfile) {
        this.queueProfile = queueProfile;
    }

    public Integer getQueueTimeout() {
        return this.queueTimeout;
    }

    public void setQueueTimeout(Integer queueTimeout) {
        this.queueTimeout = queueTimeout;
    }

    public ThreadingProfile getThreadingProfile() {
        return this.threadingProfile;
    }

    public void setThreadingProfile(ThreadingProfile threadingProfile) {
        this.threadingProfile = threadingProfile;
    }
}

