/*
 * Decompiled with CFR 0.152.
 */
package org.mule.lifecycle;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.LifecycleCallback;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.lifecycle.LifecyclePhase;
import org.mule.api.lifecycle.RegistryLifecycleHelpers;
import org.mule.api.registry.Registry;
import org.mule.lifecycle.EmptyLifecycleCallback;
import org.mule.lifecycle.LifecycleManagerSupport;
import org.mule.lifecycle.LifecycleObject;
import org.mule.lifecycle.phases.ContainerManagedLifecyclePhase;
import org.mule.lifecycle.phases.MuleContextDisposePhase;
import org.mule.lifecycle.phases.MuleContextInitialisePhase;
import org.mule.lifecycle.phases.MuleContextStartPhase;
import org.mule.lifecycle.phases.MuleContextStopPhase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryLifecycleManager
extends LifecycleManagerSupport<Registry>
implements RegistryLifecycleHelpers {
    protected Map<String, LifecyclePhase> phases = new HashMap<String, LifecyclePhase>();
    private TreeMap<String, LifecycleCallback> callbacks = new TreeMap();
    private MuleContext muleContext;

    public RegistryLifecycleManager(String id, Registry object, MuleContext muleContext) {
        super(id, object);
        this.muleContext = muleContext;
        RegistryLifecycleCallback callback = new RegistryLifecycleCallback();
        this.registerPhase("not in lifecycle", NOT_IN_LIFECYCLE_PHASE, new EmptyLifecycleCallback());
        this.registerPhase("initialise", new MuleContextInitialisePhase(), callback);
        this.registerPhase("start", new MuleContextStartPhase(), callback);
        this.registerPhase("stop", new MuleContextStopPhase(), callback);
        this.registerPhase("dispose", new MuleContextDisposePhase(), callback);
    }

    public RegistryLifecycleManager(String id, Registry object, Map<String, LifecyclePhase> phases) {
        super(id, object);
        RegistryLifecycleCallback callback = new RegistryLifecycleCallback();
        this.registerPhase("not in lifecycle", NOT_IN_LIFECYCLE_PHASE, new LifecycleCallback(){

            public void onTransition(String phaseName, Object object) throws MuleException {
            }
        });
        for (Map.Entry<String, LifecyclePhase> entry : phases.entrySet()) {
            this.registerPhase(entry.getKey(), entry.getValue(), callback);
        }
    }

    @Override
    protected void registerTransitions() {
        this.addDirectTransition("not in lifecycle", "initialise");
        this.addDirectTransition("initialise", "start");
        this.addDirectTransition("start", "stop");
        this.addDirectTransition("stop", "start");
    }

    @Override
    public void checkPhase(String name) throws IllegalStateException {
        if ("dispose".equals(name) && !this.state.isDisposed()) {
            return;
        }
        super.checkPhase(name);
    }

    protected void registerPhase(String phaseName, LifecyclePhase phase, LifecycleCallback callback) {
        this.phaseNames.add(phaseName);
        this.callbacks.put(phaseName, callback);
        this.phases.put(phaseName, phase);
    }

    @Override
    public void fireLifecycle(String destinationPhase) throws LifecycleException {
        this.checkPhase(destinationPhase);
        if (this.isDirectTransition(destinationPhase)) {
            this.invokePhase(destinationPhase, this.object, this.callbacks.get(destinationPhase));
        } else {
            boolean start = false;
            for (String phase : this.phaseNames) {
                if (start) {
                    this.invokePhase(phase, this.object, this.callbacks.get(phase));
                    if (phase.equals(destinationPhase)) break;
                }
                if (!phase.equals(this.getCurrentPhase())) continue;
                start = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void invokePhase(String phase, Object object, LifecycleCallback callback) throws LifecycleException {
        try {
            this.setExecutingPhase(phase);
            callback.onTransition(phase, object);
            this.setCurrentPhase(phase);
        }
        catch (MuleException e) {
            e.printStackTrace();
        }
        finally {
            this.setExecutingPhase(null);
        }
    }

    @Override
    public void applyPhase(Object object, String fromPhase, String toPhase) throws LifecycleException {
        if (fromPhase == null || toPhase == null) {
            throw new IllegalArgumentException("toPhase and fromPhase must be null");
        }
        if (!this.phaseNames.contains(fromPhase)) {
            throw new IllegalArgumentException("fromPhase '" + fromPhase + "' not a valid phase.");
        }
        if (!this.phaseNames.contains(toPhase)) {
            throw new IllegalArgumentException("toPhase '" + fromPhase + "' not a valid phase.");
        }
        boolean start = false;
        for (String phaseName : this.phaseNames) {
            if (start) {
                this.phases.get(phaseName).applyLifecycle(object);
            }
            if (toPhase.equals(phaseName)) break;
            if (!phaseName.equals(fromPhase)) continue;
            start = true;
        }
    }

    @Override
    public void applyCompletedPhases(Object object) throws LifecycleException {
        String lastPhase = "not in lifecycle";
        for (String phase : this.completedPhases) {
            if (!this.isDirectTransition(lastPhase, phase)) continue;
            LifecyclePhase lp = this.phases.get(phase);
            lp.applyLifecycle(object);
            lastPhase = phase;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RegistryLifecycleCallback
    implements LifecycleCallback<Object> {
        protected final transient Log logger = LogFactory.getLog(RegistryLifecycleCallback.class);

        RegistryLifecycleCallback() {
        }

        @Override
        public void onTransition(String phaseName, Object object) throws MuleException {
            LifecyclePhase phase = RegistryLifecycleManager.this.phases.get(phaseName);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Applying lifecycle phase: " + phase + " for registry: " + object.getClass().getSimpleName()));
            }
            if (phase instanceof ContainerManagedLifecyclePhase) {
                phase.applyLifecycle(object);
                return;
            }
            HashSet duplicates = new HashSet();
            for (LifecycleObject lo : phase.getOrderedLifecycleObjects()) {
                Collection targetsObj = ((Registry)RegistryLifecycleManager.this.getLifecycleObject()).lookupObjects(lo.getType());
                LinkedList targets = new LinkedList(targetsObj);
                if (targets.size() == 0) continue;
                lo.firePreNotification(RegistryLifecycleManager.this.muleContext);
                Iterator target = targets.iterator();
                while (target.hasNext()) {
                    Object o = target.next();
                    if (duplicates.contains(o)) {
                        target.remove();
                        continue;
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("lifecycle phase: " + phase.getName() + " for object: " + o));
                    }
                    phase.applyLifecycle(o);
                    target.remove();
                    duplicates.add(o);
                }
                lo.firePostNotification(RegistryLifecycleManager.this.muleContext);
            }
        }
    }
}

