/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression.transformers;

import java.util.ArrayList;
import java.util.List;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.config.i18n.CoreMessages;
import org.mule.expression.transformers.ExpressionArgument;
import org.mule.transformer.AbstractMessageAwareTransformer;
import org.mule.transformer.types.DataTypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExpressionTransformer
extends AbstractMessageAwareTransformer {
    protected List<ExpressionArgument> arguments;

    public AbstractExpressionTransformer() {
        this.registerSourceType(Object.class);
        this.setReturnDataType(DataTypeFactory.create(Object.class));
        this.arguments = new ArrayList<ExpressionArgument>(4);
    }

    public void addArgument(ExpressionArgument argument) {
        this.arguments.add(argument);
    }

    public boolean removeArgument(ExpressionArgument argument) {
        return this.arguments.remove(argument);
    }

    @Override
    public void initialise() throws InitialisationException {
        if (this.arguments == null || this.arguments.size() == 0) {
            throw new InitialisationException(CoreMessages.objectIsNull("arguments[]"), (Initialisable)this);
        }
        for (ExpressionArgument argument : this.arguments) {
            argument.setMuleContext(this.muleContext);
            argument.setExpressionEvaluationClassLoader(Thread.currentThread().getContextClassLoader());
            try {
                argument.validate();
            }
            catch (Exception e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
    }

    public List<ExpressionArgument> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<ExpressionArgument> arguments) {
        this.arguments = arguments;
    }
}

