/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint.outbound;

import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.transport.DispatchException;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.transport.AbstractConnector;

public class OutboundTryCatchMessageProcessor
extends AbstractInterceptingMessageProcessor {
    private OutboundEndpoint endpoint;
    private AbstractConnector connector;

    public OutboundTryCatchMessageProcessor(OutboundEndpoint endpoint) {
        this.endpoint = endpoint;
        this.connector = (AbstractConnector)endpoint.getConnector();
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        boolean singleThread = this.endpoint.isSynchronous() || this.endpoint.getTransactionConfig().isTransacted();
        try {
            return this.processNext(event);
        }
        catch (DispatchException e) {
            this.connector.handleException(e);
            if (singleThread) {
                throw e;
            }
            return null;
        }
        catch (Exception e) {
            this.connector.handleException(e);
            if (singleThread) {
                throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
            }
            return null;
        }
    }
}

