/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint.inbound;

import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.processor.AbstractMessageObserver;
import org.mule.util.StringMessageUtils;

public class InboundLoggingMessageProcessor
extends AbstractMessageObserver {
    protected InboundEndpoint endpoint;

    public InboundLoggingMessageProcessor(InboundEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public void observe(MuleEvent event) {
        MuleMessage message = event.getMessage();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Message Received from: " + this.endpoint.getEndpointURI()));
        }
        if (this.logger.isTraceEnabled()) {
            try {
                this.logger.trace((Object)("Message Payload: \n" + StringMessageUtils.truncate(StringMessageUtils.toString(message.getPayload()), 200, false)));
                this.logger.trace((Object)("Message detail: \n" + StringMessageUtils.headersToString(message)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

