/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint.inbound;

import org.mule.DefaultMuleEvent;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.routing.filter.FilterException;
import org.mule.config.i18n.CoreMessages;
import org.mule.processor.AbstractInterceptingMessageProcessor;

public class InboundFilterMessageProcessor
extends AbstractInterceptingMessageProcessor {
    public MuleEvent process(MuleEvent event) throws MuleException {
        MuleMessage message = event.getMessage();
        InboundEndpoint endpoint = (InboundEndpoint)event.getEndpoint();
        if (endpoint.getFilter() != null && !endpoint.getFilter().accept(message)) {
            RequestContext.setEvent(new DefaultMuleEvent(message, event));
            throw new FilterException(CoreMessages.messageRejectedByFilter(), endpoint.getFilter());
        }
        return this.processNext(event);
    }

    protected MuleMessage handleUnacceptedFilter(MuleMessage message, InboundEndpoint endpoint) {
        String messageId = message.getUniqueId();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Message " + messageId + " failed to pass filter on endpoint: " + endpoint + ". Message is being ignored"));
        }
        return message;
    }
}

