/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config;

import edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.RejectedExecutionHandler;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import org.mule.api.MuleContext;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.context.MuleContextAware;
import org.mule.api.context.WorkManager;
import org.mule.config.ImmutableThreadingProfile;
import org.mule.config.pool.ThreadPoolFactory;

public class ChainedThreadingProfile
implements ThreadingProfile {
    private Integer maxThreadsActive;
    private Integer maxThreadsIdle;
    private Integer maxBufferSize;
    private Long threadTTL;
    private Long threadWaitTimeout;
    private Integer poolExhaustedAction;
    private Boolean doThreading;
    private ThreadPoolFactory poolFactory = ThreadPoolFactory.newInstance();
    private ThreadingProfile.WorkManagerFactory workManagerFactory = new ImmutableThreadingProfile.DefaultWorkManagerFactory();
    private RejectedExecutionHandler rejectedExecutionHandler;
    private ThreadFactory threadFactory;
    private ThreadingProfile delegate;
    private MuleContext muleContext;

    public ChainedThreadingProfile() {
        this(DEFAULT_THREADING_PROFILE);
    }

    public ChainedThreadingProfile(ThreadingProfile delegate) {
        this(delegate, true);
    }

    public ChainedThreadingProfile(ThreadingProfile delegate, boolean dynamic) {
        if (!dynamic) {
            delegate = new ImmutableThreadingProfile(delegate);
        }
        this.delegate = delegate;
    }

    public int getMaxThreadsActive() {
        return null != this.maxThreadsActive ? this.maxThreadsActive.intValue() : this.delegate.getMaxThreadsActive();
    }

    public int getMaxThreadsIdle() {
        return null != this.maxThreadsIdle ? this.maxThreadsIdle.intValue() : this.delegate.getMaxThreadsIdle();
    }

    public long getThreadTTL() {
        return null != this.threadTTL ? this.threadTTL.longValue() : this.delegate.getThreadTTL();
    }

    public long getThreadWaitTimeout() {
        return null != this.threadWaitTimeout ? this.threadWaitTimeout.longValue() : this.delegate.getThreadWaitTimeout();
    }

    public int getPoolExhaustedAction() {
        return null != this.poolExhaustedAction ? this.poolExhaustedAction.intValue() : this.delegate.getPoolExhaustedAction();
    }

    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.rejectedExecutionHandler;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setMaxThreadsActive(int maxThreadsActive) {
        this.maxThreadsActive = maxThreadsActive;
    }

    public void setMaxThreadsIdle(int maxThreadsIdle) {
        this.maxThreadsIdle = maxThreadsIdle;
    }

    public void setThreadTTL(long threadTTL) {
        this.threadTTL = threadTTL;
    }

    public void setThreadWaitTimeout(long threadWaitTimeout) {
        this.threadWaitTimeout = threadWaitTimeout;
    }

    public void setPoolExhaustedAction(int poolExhaustPolicy) {
        this.poolExhaustedAction = poolExhaustPolicy;
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        this.rejectedExecutionHandler = rejectedExecutionHandler;
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    public int getMaxBufferSize() {
        return null != this.maxBufferSize ? this.maxBufferSize.intValue() : this.delegate.getMaxBufferSize();
    }

    public void setMaxBufferSize(int maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
    }

    public ThreadingProfile.WorkManagerFactory getWorkManagerFactory() {
        return this.workManagerFactory;
    }

    public void setWorkManagerFactory(ThreadingProfile.WorkManagerFactory workManagerFactory) {
        this.workManagerFactory = workManagerFactory;
    }

    public WorkManager createWorkManager(String name, int shutdownTimeout) {
        return this.workManagerFactory.createWorkManager(new ImmutableThreadingProfile(this), name, shutdownTimeout);
    }

    public ExecutorService createPool() {
        return this.createPool(null);
    }

    public ExecutorService createPool(String name) {
        return this.poolFactory.createPool(name, new ImmutableThreadingProfile(this));
    }

    public boolean isDoThreading() {
        return null != this.doThreading ? this.doThreading.booleanValue() : this.delegate.isDoThreading();
    }

    public void setDoThreading(boolean doThreading) {
        this.doThreading = doThreading;
    }

    public ThreadPoolFactory getPoolFactory() {
        return this.poolFactory;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
        if (this.workManagerFactory instanceof MuleContextAware) {
            ((MuleContextAware)((Object)this.workManagerFactory)).setMuleContext(muleContext);
        }
        this.poolFactory.setMuleContext(muleContext);
    }

    public String toString() {
        return "ThreadingProfile{maxThreadsActive=" + this.maxThreadsActive + ", maxThreadsIdle=" + this.maxThreadsIdle + ", maxBufferSize=" + this.maxBufferSize + ", threadTTL=" + this.threadTTL + ", poolExhaustedAction=" + this.poolExhaustedAction + ", threadWaitTimeout=" + this.threadWaitTimeout + ", doThreading=" + this.doThreading + ", workManagerFactory=" + this.workManagerFactory + ", rejectedExecutionHandler=" + this.rejectedExecutionHandler + ", threadFactory=" + this.threadFactory + "}";
    }
}

