/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.RequestContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointNotFoundException;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.routing.OutboundRouterCollection;
import org.mule.api.security.SecurityContext;
import org.mule.api.service.Service;
import org.mule.api.transport.DispatchException;
import org.mule.api.transport.ReceiveException;
import org.mule.api.transport.SessionHandler;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.CaseInsensitiveHashMap;
import org.mule.util.UUID;
import org.mule.util.store.DeserializationPostInitialisable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultMuleSession
implements MuleSession,
DeserializationPostInitialisable {
    private static final long serialVersionUID = 3380926585676521866L;
    private static Log logger = LogFactory.getLog(DefaultMuleSession.class);
    private transient FlowConstruct flowConstruct = null;
    private boolean valid = true;
    private String id;
    private SecurityContext securityContext;
    private Map properties = null;
    private transient MuleContext muleContext;
    private transient Map<String, Object> serializedData = null;

    public DefaultMuleSession(MuleContext muleContext) {
        this((FlowConstruct)null, muleContext);
    }

    public DefaultMuleSession(FlowConstruct flowConstruct, MuleContext muleContext) {
        this.muleContext = muleContext;
        this.properties = new CaseInsensitiveHashMap();
        this.id = UUID.getUUID();
        this.flowConstruct = flowConstruct;
    }

    @Deprecated
    public DefaultMuleSession(MuleMessage message, SessionHandler requestSessionHandler, FlowConstruct flowConstruct, MuleContext muleContext) throws MuleException {
        this(message, requestSessionHandler, muleContext);
        if (flowConstruct == null) {
            throw new IllegalArgumentException(CoreMessages.propertiesNotSet("flowConstruct").toString());
        }
        this.flowConstruct = flowConstruct;
    }

    @Deprecated
    public DefaultMuleSession(MuleMessage message, SessionHandler requestSessionHandler, MuleContext muleContext) throws MuleException {
        this(muleContext);
        if (requestSessionHandler == null) {
            throw new IllegalArgumentException(CoreMessages.propertiesNotSet("requestSessionHandler").toString());
        }
        if (message == null) {
            throw new IllegalArgumentException(CoreMessages.propertiesNotSet("message").toString());
        }
        this.properties = new CaseInsensitiveMap();
        requestSessionHandler.retrieveSessionInfoFromMessage(message, this);
        this.id = (String)this.getProperty(requestSessionHandler.getSessionIDKey());
        if (this.id == null) {
            this.id = UUID.getUUID();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("There is no session id on the request using key: " + requestSessionHandler.getSessionIDKey() + ". Generating new session id: " + this.id));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Got session with id: " + this.id));
        }
    }

    public DefaultMuleSession(MuleSession session, MuleContext muleContext) {
        this.muleContext = muleContext;
        this.id = session.getId();
        this.securityContext = session.getSecurityContext();
        this.flowConstruct = session.getFlowConstruct();
        this.valid = session.isValid();
        this.properties = new HashMap();
        for (Object key : session.getPropertyNamesAsSet()) {
            this.properties.put(key, session.getProperty(key));
        }
    }

    @Override
    public void dispatchEvent(MuleMessage message) throws MuleException {
        if (this.flowConstruct == null) {
            throw new IllegalStateException(CoreMessages.objectIsNull("flowConstruct").getMessage());
        }
        if (!(this.flowConstruct instanceof Service)) {
            throw new UnsupportedOperationException("MuleSession.dispatchEvent is only supported when flow constuct is a Service");
        }
        OutboundRouterCollection router = ((Service)this.flowConstruct).getOutboundRouter();
        if (router == null) {
            throw new EndpointNotFoundException(CoreMessages.noOutboundRouterSetOn(this.flowConstruct.getName()));
        }
        router.process(new DefaultMuleEvent(message, RequestContext.getEvent()));
    }

    @Override
    public void dispatchEvent(MuleMessage message, String endpointName) throws MuleException {
        this.dispatchEvent(message, this.muleContext.getRegistry().lookupEndpointFactory().getOutboundEndpoint(endpointName));
    }

    @Override
    public void dispatchEvent(MuleMessage message, OutboundEndpoint endpoint) throws MuleException {
        if (endpoint == null) {
            logger.warn((Object)"Endpoint argument is null, using outbound router to determine endpoint.");
            this.dispatchEvent(message);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("MuleSession has received asynchronous event on: " + endpoint));
        }
        MuleEvent event = this.createOutboundEvent(message, endpoint, null);
        this.dispatchEvent(event);
    }

    @Override
    public MuleMessage sendEvent(MuleMessage message, String endpointName) throws MuleException {
        return this.sendEvent(message, this.muleContext.getRegistry().lookupEndpointFactory().getOutboundEndpoint(endpointName));
    }

    @Override
    public MuleMessage sendEvent(MuleMessage message) throws MuleException {
        if (this.flowConstruct == null) {
            throw new IllegalStateException(CoreMessages.objectIsNull("flowConstruct").getMessage());
        }
        if (!(this.flowConstruct instanceof Service)) {
            throw new UnsupportedOperationException("MuleSession.sendEvent is only supported when flow constuct is a Service");
        }
        OutboundRouterCollection router = ((Service)this.flowConstruct).getOutboundRouter();
        if (router == null) {
            throw new EndpointNotFoundException(CoreMessages.noOutboundRouterSetOn(this.flowConstruct.getName()));
        }
        MuleEvent result = router.process(new DefaultMuleEvent(message, RequestContext.getEvent()));
        if (result != null) {
            return result.getMessage();
        }
        return null;
    }

    @Override
    public MuleMessage sendEvent(MuleMessage message, OutboundEndpoint endpoint) throws MuleException {
        if (endpoint == null) {
            logger.warn((Object)"Endpoint argument is null, using outbound router to determine endpoint.");
            return this.sendEvent(message);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("MuleSession has received synchronous event on endpoint: " + endpoint));
        }
        MuleEvent event = this.createOutboundEvent(message, endpoint, null);
        return this.sendEvent(event);
    }

    @Override
    public void dispatchEvent(MuleEvent event) throws MuleException {
        if (event.getEndpoint() instanceof OutboundEndpoint) {
            ((OutboundEndpoint)event.getEndpoint()).process(event);
        } else {
            if (this.flowConstruct == null) {
                throw new DispatchException(CoreMessages.noComponentForEndpoint(), event.getMessage(), event.getEndpoint());
            }
            if (!(this.flowConstruct instanceof Service)) {
                throw new UnsupportedOperationException("MuleSession.dispatchEvent is only supported when flow constuct is a Service");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("dispatching event to service: " + this.flowConstruct.getName() + ", event is: " + event));
            }
            ((Service)this.flowConstruct).dispatchEvent(event);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public MuleMessage sendEvent(MuleEvent event) throws MuleException {
        int timeout = event.getMessage().getIntProperty("MULE_EVENT_TIMEOUT", -1);
        if (timeout >= 0) {
            event.setTimeout(timeout);
        }
        if (event.getEndpoint() instanceof OutboundEndpoint) {
            MuleEvent resultEvent = ((OutboundEndpoint)event.getEndpoint()).process(event);
            if (resultEvent != null) {
                return resultEvent.getMessage();
            }
            return null;
        }
        if (this.flowConstruct == null) {
            throw new DispatchException(CoreMessages.noComponentForEndpoint(), event.getMessage(), event.getEndpoint());
        }
        if (!(this.flowConstruct instanceof Service)) {
            throw new UnsupportedOperationException("MuleSession.sendEvent is only supported when flow constuct is a Service");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("sending event to service: " + this.flowConstruct.getName() + " event is: " + event));
        }
        return ((Service)this.flowConstruct).sendEvent(event);
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setValid(boolean value) {
        this.valid = value;
    }

    @Override
    public MuleMessage requestEvent(String endpointName, long timeout) throws MuleException {
        InboundEndpoint endpoint = this.muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint(endpointName);
        return this.requestEvent(endpoint, timeout);
    }

    @Override
    public MuleMessage requestEvent(InboundEndpoint endpoint, long timeout) throws MuleException {
        try {
            return endpoint.request(timeout);
        }
        catch (Exception e) {
            throw new ReceiveException(endpoint, timeout, e);
        }
    }

    @Override
    public MuleEvent createOutboundEvent(MuleMessage message, OutboundEndpoint endpoint, MuleEvent previousEvent) throws MuleException {
        if (endpoint == null) {
            throw new DispatchException(CoreMessages.objectIsNull("Outbound Endpoint"), message, endpoint);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating event with data: " + message.getPayload().getClass().getName() + ", for endpoint: " + endpoint));
        }
        try {
            DefaultMuleEvent event = previousEvent != null ? new DefaultMuleEvent(message, (ImmutableEndpoint)endpoint, this.flowConstruct, previousEvent) : new DefaultMuleEvent(message, (ImmutableEndpoint)endpoint, this, null);
            return event;
        }
        catch (Exception e) {
            throw new DispatchException(CoreMessages.failedToCreate("MuleEvent"), message, endpoint, e);
        }
    }

    @Override
    public FlowConstruct getFlowConstruct() {
        return this.flowConstruct;
    }

    @Override
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }

    @Override
    public void setSecurityContext(SecurityContext context) {
        this.securityContext = context;
    }

    @Override
    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    @Override
    public void setProperty(Object key, Object value) {
        this.properties.put(key, value);
    }

    @Override
    public Object getProperty(Object key) {
        return this.properties.get(key);
    }

    @Override
    public Object removeProperty(Object key) {
        return this.properties.remove(key);
    }

    @Override
    @Deprecated
    public Iterator<String> getPropertyNames() {
        return this.properties.keySet().iterator();
    }

    @Override
    public Set<String> getPropertyNamesAsSet() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.getFlowConstruct() != null) {
            out.writeObject(this.getFlowConstruct() != null ? this.getFlowConstruct().getName() : "null");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.serializedData = new HashMap<String, Object>();
        try {
            this.serializedData.put("serviceName", in.readObject());
        }
        catch (OptionalDataException optionalDataException) {
            // empty catch block
        }
    }

    void initAfterDeserialisation(MuleContext muleContext) throws MuleException {
        String serviceName = (String)this.serializedData.get("serviceName");
        if (serviceName != null) {
            this.flowConstruct = muleContext.getRegistry().lookupService(serviceName);
        }
        this.serializedData = null;
    }
}

