/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.util.StringMessageUtils;

public abstract class SplashScreen {
    protected List<String> header = new ArrayList<String>();
    protected List<String> body = new ArrayList<String>();
    protected List<String> footer = new ArrayList<String>();
    private static Log logger = LogFactory.getLog(SplashScreen.class);
    private static final Map instances = new HashMap();

    public static synchronized SplashScreen getInstance(Class clazz) {
        SplashScreen splashScreen = (SplashScreen)instances.get(clazz);
        if (splashScreen == null) {
            try {
                splashScreen = (SplashScreen)clazz.newInstance();
                instances.put(clazz, splashScreen);
            }
            catch (Exception ignore) {
                logger.debug((Object)ignore);
            }
        }
        return splashScreen;
    }

    public static void dispose() {
        instances.clear();
    }

    public final void setHeader(MuleContext context) {
        this.header.clear();
        this.doHeader(context);
    }

    public final void addBody(String line) {
        this.doBody(line);
    }

    public final void setFooter(MuleContext context) {
        this.footer.clear();
        this.doFooter(context);
    }

    protected void doHeader(MuleContext context) {
    }

    protected void doBody(String line) {
        this.body.add(line);
    }

    protected void doFooter(MuleContext context) {
    }

    public String toString() {
        ArrayList<String> boilerPlate = new ArrayList<String>(this.header);
        boilerPlate.addAll(this.body);
        boilerPlate.addAll(this.footer);
        return StringMessageUtils.getBoilerPlate(boilerPlate, '*', 70);
    }

    protected SplashScreen() {
    }
}

