/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointFactory;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.transport.DispatchException;
import org.mule.api.transport.ReplyToHandler;
import org.mule.config.i18n.CoreMessages;
import org.mule.service.AbstractService;

public class DefaultReplyToHandler
implements ReplyToHandler {
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    private volatile List transformers;
    private final Map<String, ImmutableEndpoint> endpointCache = new HashMap<String, ImmutableEndpoint>();
    protected MuleContext muleContext;

    public DefaultReplyToHandler(List transformers, MuleContext muleContext) {
        this.transformers = transformers;
        this.muleContext = muleContext;
    }

    public void processReplyTo(MuleEvent event, MuleMessage returnMessage, Object replyTo) throws MuleException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("sending reply to: " + replyTo));
        }
        String replyToEndpoint = replyTo.toString();
        OutboundEndpoint endpoint = this.getEndpoint(event, replyToEndpoint);
        returnMessage.removeProperty("MULE_REPLYTO");
        returnMessage.removeProperty("MULE_REMOTE_SYNC");
        DefaultMuleEvent replyToEvent = new DefaultMuleEvent(returnMessage, (ImmutableEndpoint)endpoint, event.getSession(), false);
        try {
            ((AbstractService)event.getService()).getStatistics().incSentReplyToEvent();
            endpoint.dispatch(replyToEvent);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("reply to sent: " + endpoint));
            }
        }
        catch (Exception e) {
            throw new DispatchException(CoreMessages.failedToDispatchToReplyto(endpoint), replyToEvent.getMessage(), replyToEvent.getEndpoint(), e);
        }
    }

    protected synchronized OutboundEndpoint getEndpoint(MuleEvent event, String endpointUri) throws MuleException {
        OutboundEndpoint endpoint = (OutboundEndpoint)this.endpointCache.get(endpointUri);
        if (endpoint == null) {
            EndpointFactory endpointFactory = this.muleContext.getRegistry().lookupEndpointFactory();
            EndpointBuilder endpointBuilder = endpointFactory.getEndpointBuilder(endpointUri);
            if (this.transformers == null) {
                endpointBuilder.setTransformers(event.getEndpoint().getResponseTransformers());
            }
            endpoint = endpointFactory.getOutboundEndpoint(endpointBuilder);
            this.endpointCache.put(endpointUri, endpoint);
        }
        return endpoint;
    }

    public List getTransformers() {
        return this.transformers;
    }

    public void setTransformers(List transformers) {
        this.transformers = transformers;
    }
}

