/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.types;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.DataType;
import org.mule.transformer.types.CollectionDataType;
import org.mule.transformer.types.SimpleDataType;
import org.mule.util.generics.GenericsUtils;
import org.mule.util.generics.MethodParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTypeFactory {
    public static final DataType<String> TEXT_STRING = new SimpleDataType<String>(String.class, "text/plain");
    public static final DataType<String> XML_STRING = new SimpleDataType<String>(String.class, "text/xml");
    public static final DataType<String> JSON_STRING = new SimpleDataType<String>(String.class, "application/json");
    public static final DataType<String> HTML_STRING = new SimpleDataType<String>(String.class, "text/html");
    public static final DataType<String> ATOM_STRING = new SimpleDataType<String>(String.class, "application/atom+xml");
    public static final DataType<String> RSS_STRING = new SimpleDataType<String>(String.class, "application/rss+xml");

    public <T> DataType<T> create(Class<T> type) {
        return this.create(type, "*/*");
    }

    public <T> DataType<T> create(Class<?> type, String mimeType) {
        if (Collection.class.isAssignableFrom(type)) {
            Class<?> cType = type;
            Class<?> itemType = GenericsUtils.getCollectionType(cType);
            if (itemType == null) {
                return new CollectionDataType(cType, mimeType);
            }
            return new CollectionDataType(cType, itemType, mimeType);
        }
        if (Proxy.isProxyClass(type)) {
            type = type.getInterfaces()[0];
        }
        return new SimpleDataType(type, mimeType);
    }

    public DataType create(Class<? extends Collection> collClass, Class itemType) {
        return this.create(collClass, itemType, null);
    }

    public DataType create(Class<? extends Collection> collClass, Class itemType, String mimeType) {
        return new CollectionDataType(collClass, itemType, mimeType);
    }

    public DataType createFromObject(Object o) {
        Class<?> type = o.getClass();
        String mime = null;
        if (o instanceof MuleMessage) {
            MuleMessage mm = (MuleMessage)o;
            type = mm.getPayload().getClass();
            mime = mm.getStringProperty("Content-Type", null);
            if (mime != null) {
                int i = mime.indexOf(";");
                String string = mime = i > -1 ? mime.substring(0, i) : mime;
            }
        }
        if (mime == null) {
            mime = "*/*";
        }
        return this.create(type, mime);
    }

    public DataType createFromReturnType(Method m) {
        return this.createFromReturnType(m, null);
    }

    public DataType createFromReturnType(Method m, String mimeType) {
        if (Collection.class.isAssignableFrom(m.getReturnType())) {
            Class<?> cType = m.getReturnType();
            Class<?> itemType = GenericsUtils.getCollectionReturnType(m);
            if (itemType != null) {
                return new CollectionDataType(cType, itemType, mimeType);
            }
            return new CollectionDataType(cType, mimeType);
        }
        return new SimpleDataType(m.getReturnType(), mimeType);
    }

    public DataType createFromParameterType(Method m, int paramIndex) {
        return this.createFromParameterType(m, paramIndex, null);
    }

    public DataType createFromParameterType(Method m, int paramIndex, String mimeType) {
        if (Collection.class.isAssignableFrom(m.getParameterTypes()[paramIndex])) {
            Class<?> cType = m.getParameterTypes()[paramIndex];
            Class<?> itemType = GenericsUtils.getCollectionParameterType(new MethodParameter(m, paramIndex));
            if (itemType != null) {
                return new CollectionDataType(cType, itemType, mimeType);
            }
            return new CollectionDataType(cType, mimeType);
        }
        return new SimpleDataType(m.getParameterTypes()[paramIndex], mimeType);
    }

    public DataType createFromField(Field f) {
        return this.createFromField(f, null);
    }

    public DataType createFromField(Field f, String mimeType) {
        if (Collection.class.isAssignableFrom(f.getType())) {
            Class<?> cType = f.getType();
            Class<?> itemType = GenericsUtils.getCollectionFieldType(f);
            if (itemType != null) {
                return new CollectionDataType(cType, itemType, mimeType);
            }
            return new CollectionDataType(cType, mimeType);
        }
        return new SimpleDataType(f.getType(), mimeType);
    }
}

