/*
 * Decompiled with CFR 0.152.
 */
package org.mule.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.RegistrationException;
import org.mule.api.registry.Registry;
import org.mule.api.registry.RegistryBroker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRegistryBroker
implements RegistryBroker {
    @Override
    public void initialise() throws InitialisationException {
        try {
            this.fireLifecycle("initialise");
        }
        catch (InitialisationException e) {
            throw e;
        }
        catch (MuleException me) {
            throw new InitialisationException((Throwable)me, (Initialisable)this);
        }
    }

    @Override
    public void dispose() {
        for (Registry registry : this.getRegistries()) {
            try {
                registry.fireLifecycle("dispose");
            }
            catch (MuleException muleException) {}
        }
    }

    @Override
    public void fireLifecycle(String phase) throws MuleException {
        for (Registry registry : this.getRegistries()) {
            registry.fireLifecycle(phase);
        }
    }

    @Override
    public String getRegistryId() {
        return this.toString();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    protected abstract Collection<Registry> getRegistries();

    @Override
    public <T> T get(String key) {
        return this.lookupObject(key);
    }

    @Override
    public <T> T lookupObject(String key) {
        T obj = null;
        Iterator<Registry> it = this.getRegistries().iterator();
        while (obj == null && it.hasNext()) {
            obj = it.next().lookupObject(key);
        }
        return obj;
    }

    @Override
    public <T> T lookupObject(Class<T> type) throws RegistrationException {
        Collection<T> objects = this.lookupObjects(type);
        if (objects.size() == 1) {
            return objects.iterator().next();
        }
        if (objects.size() > 1) {
            throw new RegistrationException("More than one object of type " + type + " registered but only one expected.");
        }
        return null;
    }

    @Override
    public <T> Collection<T> lookupObjects(Class<T> type) {
        ArrayList<T> objects = new ArrayList<T>();
        Iterator<Registry> it = this.getRegistries().iterator();
        while (it.hasNext()) {
            objects.addAll(it.next().lookupObjects(type));
        }
        return objects;
    }

    @Override
    public <T> Map<String, T> lookupByType(Class<T> type) {
        HashMap<String, T> results = new HashMap<String, T>();
        for (Registry registry : this.getRegistries()) {
            results.putAll(registry.lookupByType(type));
        }
        return results;
    }

    @Override
    public void registerObject(String key, Object value) throws RegistrationException {
        this.registerObject(key, value, null);
    }

    @Override
    public void registerObject(String key, Object value, Object metadata) throws RegistrationException {
        for (Registry reg : this.getRegistries()) {
            if (reg.isReadOnly()) continue;
            reg.registerObject(key, value, metadata);
            break;
        }
    }

    public void registerObjects(Map objects) throws RegistrationException {
        for (Object key : objects.keySet()) {
            this.registerObject((String)key, objects.get(key));
        }
    }

    @Override
    public void unregisterObject(String key) throws RegistrationException {
        this.unregisterObject(key, null);
    }

    @Override
    public void unregisterObject(String key, Object metadata) throws RegistrationException {
        for (Registry reg : this.getRegistries()) {
            if (reg.isReadOnly() || reg.lookupObject(key) == null) continue;
            reg.unregisterObject(key, metadata);
            break;
        }
    }
}

