/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.context.MuleContextAware;
import org.mule.api.expression.ExpressionEvaluator;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.config.i18n.CoreMessages;
import org.mule.endpoint.AbstractEndpointBuilder;

public class RegistryExpressionEvaluator
implements ExpressionEvaluator,
MuleContextAware {
    protected final transient Log logger = LogFactory.getLog(RegistryExpressionEvaluator.class);
    public static final String NAME = "registry";
    private MuleContext muleContext;

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public Object evaluate(String expression, MuleMessage message) {
        Object o;
        String name;
        int i = expression.indexOf(".");
        String property = null;
        boolean propertyRequired = true;
        boolean objectRequired = true;
        if (i > 0) {
            name = expression.substring(0, i);
            property = expression.substring(i + 1);
            if (property.endsWith("*")) {
                propertyRequired = false;
                property = property.substring(property.length() - 1);
            }
        } else {
            name = expression;
        }
        if (name.endsWith("*")) {
            objectRequired = false;
            name = name.substring(name.length() - 1);
        }
        if ((o = this.muleContext.getRegistry().lookupObject(name)) == null && objectRequired) {
            throw new ExpressionRuntimeException(CoreMessages.expressionEvaluatorReturnedNull(NAME, expression));
        }
        if (o == null || property == null) {
            return o;
        }
        if (this.muleContext.getExpressionManager().isEvaluatorRegistered("bean")) {
            Object p;
            if (o instanceof AbstractEndpointBuilder) {
                property = "endpointBuilder.endpoint." + property;
            }
            if ((p = this.muleContext.getExpressionManager().evaluate("#[bean:" + property + "]", new DefaultMuleMessage(o, this.muleContext))) == null && propertyRequired) {
                throw new ExpressionRuntimeException(CoreMessages.expressionEvaluatorReturnedNull(NAME, name + "." + property));
            }
            return p;
        }
        throw new ExpressionRuntimeException(CoreMessages.expressionEvaluatorNotRegistered("bean"));
    }

    public String getName() {
        return NAME;
    }

    public void setName(String name) {
        throw new UnsupportedOperationException();
    }
}

