/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.scan.annotations;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.util.scan.annotations.AnnotationFilter;
import org.mule.util.scan.annotations.AnnotationInfo;
import org.mule.util.scan.annotations.AnnotationTypeFilter;
import org.mule.util.scan.annotations.AnnotationsScanner;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaAnnotationTypeFilter
implements AnnotationFilter {
    protected final transient Log logger = LogFactory.getLog(MetaAnnotationTypeFilter.class);
    private Class<? extends Annotation> annotation;
    private ClassLoader classLoader;

    public MetaAnnotationTypeFilter(Class<? extends Annotation> annotation, ClassLoader classLoader) {
        this.annotation = annotation;
        this.classLoader = classLoader;
    }

    public MetaAnnotationTypeFilter(Class<? extends Annotation> annotation) {
        this.annotation = annotation;
        this.classLoader = Thread.currentThread().getContextClassLoader();
    }

    @Override
    public boolean accept(AnnotationInfo info) {
        try {
            URL classUrl = this.getClassURL(info.getClassName());
            if (classUrl == null) {
                this.logger.debug((Object)("Failed to load annotation class: " + info));
                return false;
            }
            ClassReader r = new ClassReader(classUrl.openStream());
            MetaAnnotationScanner scanner = new MetaAnnotationScanner(new AnnotationTypeFilter(this.annotation));
            r.accept((ClassVisitor)scanner, 0);
            return scanner.getClassAnnotations().size() == 1;
        }
        catch (IOException e) {
            this.logger.debug((Object)e);
            return false;
        }
    }

    public URL getClassURL(String className) {
        String resource = className.replace(".", "/") + ".class";
        return this.classLoader.getResource(resource);
    }

    private class MetaAnnotationScanner
    extends AnnotationsScanner {
        public MetaAnnotationScanner(AnnotationFilter filter) {
            super(filter);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            this.currentAnnotation = new AnnotationInfo();
            this.currentAnnotation.setClassName(this.getAnnotationClassName(desc));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Annotation: " + this.getAnnotationClassName(desc)));
            }
            if (this.currentlyProcessing.nextSetBit(0) < 0) {
                this.currentlyProcessing.set(3);
            }
            return this;
        }
    }
}

