/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.scan;

import java.io.IOException;
import java.net.URL;
import org.mule.util.scan.ClassScanner;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.commons.EmptyVisitor;

public class ImplementationClassScanner
extends EmptyVisitor
implements ClassScanner {
    private Class implementationClass;
    private boolean match;
    private String className;
    private ClassLoader classLoader;

    public ImplementationClassScanner(Class implementationClass) {
        this(implementationClass, Thread.currentThread().getContextClassLoader());
    }

    public ImplementationClassScanner(Class implementationClass, ClassLoader classLoader) {
        if (implementationClass.isInterface()) {
            throw new IllegalArgumentException("The class need to be an implementation not an interface");
        }
        this.implementationClass = implementationClass;
        this.classLoader = classLoader;
    }

    public void visit(int i, int i1, String s, String s1, String superName, String[] interfaces) {
        if (superName == null) {
            return;
        }
        if (superName.replaceAll("/", ".").equals(this.implementationClass.getName())) {
            this.match = true;
            this.className = s;
        } else {
            try {
                ImplementationClassScanner scanner = new ImplementationClassScanner(this.implementationClass);
                URL classURL = this.getClassURL(superName);
                ClassReader r = new ClassReader(classURL.openStream());
                r.accept((ClassVisitor)scanner, 0);
                this.match = scanner.isMatch();
                this.className = scanner.getClassName();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean isMatch() {
        return this.match;
    }

    public String getClassName() {
        return this.className;
    }

    public URL getClassURL(String className) {
        String resource = className.replace(".", "/") + ".class";
        return this.classLoader.getResource(resource);
    }
}

