/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.counters.impl;

import java.security.InvalidParameterException;
import java.util.Iterator;
import java.util.LinkedList;
import org.mule.util.counters.CounterFactory;
import org.mule.util.counters.impl.AbstractCounter;
import org.mule.util.counters.impl.AggregateCounter;

public class RatePerUnit
extends AggregateCounter {
    private final LinkedList samples;
    private final long unit;
    private final long length;
    private final long baseTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RatePerUnit(String name, String p, CounterFactory.Type type, AbstractCounter base) {
        super(name, type, base);
        if (type == CounterFactory.Type.RATE_PER_SECOND) {
            this.unit = 1000L;
        } else if (type == CounterFactory.Type.RATE_PER_MINUTE) {
            this.unit = 60000L;
        } else if (type == CounterFactory.Type.RATE_PER_HOUR) {
            this.unit = 3600000L;
        } else {
            throw new InvalidParameterException();
        }
        long newLength = 0L;
        try {
            try {
                newLength = Long.parseLong(p);
            }
            catch (Exception e) {
                newLength = 0L;
                Object var9_7 = null;
                if (newLength <= 0L) {
                    newLength = 128L;
                }
                this.length = newLength;
            }
            Object var9_6 = null;
            if (newLength <= 0L) {
                newLength = 128L;
            }
            this.length = newLength;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            if (newLength <= 0L) {
                newLength = 128L;
            }
            this.length = newLength;
            throw throwable;
        }
        this.samples = new LinkedList();
        this.baseTime = System.currentTimeMillis();
    }

    public double nextValue() {
        if (this.samples.isEmpty()) {
            return 0.0;
        }
        double total = 0.0;
        long current = this.getTime();
        Iterator it = this.samples.iterator();
        Sample sample = null;
        while (it.hasNext() && current - (sample = (Sample)it.next()).time <= this.length) {
            total += sample.value;
        }
        return total / (double)(1L + current - (sample != null ? sample.time : 0L));
    }

    public void doCompute() {
        Sample l = this.samples.isEmpty() ? null : (Sample)this.samples.getFirst();
        long t = this.getTime();
        if (l == null || t > l.time) {
            Sample s = new Sample(this.getBase().nextValue(), t);
            this.samples.addFirst(s);
        } else {
            l.value += this.getBase().nextValue();
        }
        while ((long)this.samples.size() > this.length) {
            this.samples.removeLast();
        }
    }

    protected long getTime() {
        return (System.currentTimeMillis() - this.baseTime) / this.unit;
    }

    private static class Sample {
        private double value;
        private long time;

        public Sample(double value, long time) {
            this.value = value;
            this.time = time;
        }

        public long getTime() {
            return this.time;
        }

        public double getValue() {
            return this.value;
        }
    }
}

