/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.util.ArrayUtils;
import org.mule.util.StringUtils;

public class SystemUtils
extends org.apache.commons.lang.SystemUtils {
    protected static final Log logger = LogFactory.getLog(SystemUtils.class);
    private static final String[] UNIX_ENV_PREFIXES = new String[]{"declare -", "typeset -"};
    private static Map environment = null;

    public static synchronized Map getenv() {
        if (environment == null) {
            try {
                if (IS_JAVA_1_4) {
                    environment = Collections.unmodifiableMap(SystemUtils.getenvJDK14());
                } else {
                    Class<System> target = System.class;
                    Method envMethod = target.getMethod("getenv", ArrayUtils.EMPTY_CLASS_ARRAY);
                    environment = Collections.unmodifiableMap((Map)envMethod.invoke(target, (Object[])null));
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Could not access OS environment: ", (Throwable)ex);
                environment = Collections.EMPTY_MAP;
            }
        }
        return environment;
    }

    private static Map getenvJDK14() throws Exception {
        HashMap<String, String> env = new HashMap<String, String>();
        Process process = null;
        try {
            String line;
            String command;
            boolean isUnix = true;
            if (IS_OS_WINDOWS) {
                command = "cmd /c set";
                isUnix = false;
            } else {
                command = "env";
            }
            process = Runtime.getRuntime().exec(command);
            BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = br.readLine()) != null) {
                for (int prefix = 0; prefix < UNIX_ENV_PREFIXES.length; ++prefix) {
                    if (!line.startsWith(UNIX_ENV_PREFIXES[prefix])) continue;
                    line = line.substring(UNIX_ENV_PREFIXES[prefix].length());
                }
                int index = -1;
                index = line.indexOf(61);
                if (index > -1) {
                    String key = line.substring(0, index).trim();
                    String value = line.substring(index + 1).trim();
                    if (isUnix && value.length() > 1 && (value.startsWith("\"") || value.startsWith("'"))) {
                        value = value.substring(1, value.length() - 1);
                    }
                    env.put(key, value);
                    continue;
                }
                env.put(line, "");
            }
            Object var10_10 = null;
            if (process != null) {
                process.destroy();
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (process != null) {
                process.destroy();
            }
            throw throwable;
        }
        return env;
    }

    public static String getenv(String name) {
        return (String)SystemUtils.getenv().get(name);
    }

    public static boolean isSunJDK() {
        return JAVA_VM_VENDOR.toUpperCase().indexOf("SUN") != -1;
    }

    public static boolean isIbmJDK() {
        return JAVA_VM_VENDOR.toUpperCase().indexOf("IBM") != -1;
    }

    public static Map parsePropertyDefinitions(String input) {
        if (StringUtils.isEmpty((String)input)) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        int tokenStart = 0;
        while (tokenStart < input.length() && (tokenStart = StringUtils.indexOf((String)input, (String)"-D", (int)tokenStart)) != -1) {
            int keyEnd;
            int keyStart;
            if (keyStart == input.length()) break;
            char cursor = input.charAt(keyStart);
            if (cursor == ' ') continue;
            if (cursor == '=') {
                if ((tokenStart = StringUtils.indexOf((String)input, (char)' ', (int)tokenStart)) == -1) break;
                continue;
            }
            for (keyEnd = keyStart = (tokenStart += 2); keyEnd < input.length(); ++keyEnd) {
                cursor = input.charAt(keyEnd);
                if (cursor == ' ') {
                    tokenStart = keyEnd;
                    break;
                }
                if (cursor == '=') break;
            }
            String key = StringUtils.substring((String)input, (int)keyStart, (int)keyEnd);
            int valueStart = keyEnd;
            int valueEnd = keyEnd;
            String value = "true";
            if (keyEnd < input.length() && cursor != ' ') {
                valueEnd = valueStart = keyEnd + 1;
                cursor = input.charAt(valueStart);
                valueEnd = cursor == '\"' ? StringUtils.indexOf((String)input, (char)'\"', (int)(++valueStart)) : StringUtils.indexOf((String)input, (char)' ', (int)valueStart);
                if (valueEnd == -1) {
                    valueEnd = input.length();
                }
                value = StringUtils.substring((String)input, (int)valueStart, (int)valueEnd);
            }
            result.put(key, value);
            tokenStart = valueEnd;
        }
        return result;
    }
}

