/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.beans.ExceptionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleException;
import org.mule.api.context.WorkManager;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.retry.RetryCallback;
import org.mule.api.retry.RetryContext;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.api.transport.Connectable;
import org.mule.api.transport.Connector;
import org.mule.context.notification.ConnectionNotification;
import org.mule.transport.AbstractConnector;
import org.mule.util.ClassUtils;
import org.mule.util.concurrent.WaitableBoolean;

public abstract class AbstractConnectable
implements Connectable,
ExceptionListener {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected ImmutableEndpoint endpoint;
    protected final AbstractConnector connector;
    protected RetryPolicyTemplate retryTemplate;
    protected final WaitableBoolean connected = new WaitableBoolean(false);
    protected final WaitableBoolean started = new WaitableBoolean(false);
    protected final AtomicBoolean disposed = new AtomicBoolean(false);
    protected boolean startOnConnect = false;

    public AbstractConnectable(ImmutableEndpoint endpoint) {
        this.endpoint = endpoint;
        this.connector = (AbstractConnector)endpoint.getConnector();
    }

    protected void disposeAndLogException() {
        try {
            this.dispose();
        }
        catch (Throwable t) {
            this.logger.error((Object)"Could not dispose of the message dispatcher!", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionThrown(Exception e) {
        try {
            this.handleException(e);
        }
        finally {
            this.dispose();
        }
    }

    public void handleException(Exception exception) {
        this.connector.handleException(exception, this);
    }

    public boolean validate() {
        return !this.disposed.get();
    }

    public void activate() {
    }

    public void passivate() {
    }

    public void initialise() throws InitialisationException {
        this.retryTemplate = this.endpoint.getRetryPolicyTemplate() != null ? this.endpoint.getRetryPolicyTemplate() : this.connector.getRetryPolicyTemplate();
    }

    public synchronized void dispose() {
        if (!this.disposed.get()) {
            try {
                this.disconnect();
                this.stop();
            }
            catch (Exception e) {
                this.logger.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public Connector getConnector() {
        return this.connector;
    }

    public ImmutableEndpoint getEndpoint() {
        return this.endpoint;
    }

    public final synchronized void connect() throws Exception {
        if (this.disposed.get()) {
            throw new IllegalStateException("Requester/dispatcher has been disposed; cannot connect to resource");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Connecting: " + this));
        }
        this.retryTemplate.execute(new RetryCallback(){

            public void doWork(RetryContext context) throws Exception {
                try {
                    AbstractConnectable.this.doConnect();
                    AbstractConnectable.this.connected.set(true);
                    AbstractConnectable.this.logger.info((Object)("Connected: " + this.getWorkDescription()));
                    if (AbstractConnectable.this.startOnConnect) {
                        AbstractConnectable.this.start();
                    }
                }
                catch (Exception e) {
                    if (AbstractConnectable.this.logger.isDebugEnabled()) {
                        AbstractConnectable.this.logger.debug((Object)e);
                    }
                    throw e;
                }
            }

            public String getWorkDescription() {
                return AbstractConnectable.this.getConnectionDescription();
            }
        }, this.getWorkManager());
    }

    public RetryContext validateConnection(RetryContext retryContext) {
        retryContext.setOk();
        return retryContext;
    }

    public final synchronized void disconnect() throws Exception {
        if (!this.connected.get()) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Disconnecting: " + this));
        }
        this.doDisconnect();
        this.connected.set(false);
        this.logger.info((Object)("Disconnected: " + this));
        this.connector.fireNotification(new ConnectionNotification(this, this.getConnectEventId(this.endpoint), 703));
    }

    protected String getConnectEventId(ImmutableEndpoint endpoint) {
        return this.connector.getName() + ".dispatcher(" + endpoint.getEndpointURI().getUri() + ")";
    }

    public final boolean isConnected() {
        return this.connected.get();
    }

    protected boolean isDoThreading() {
        return this.connector.getDispatcherThreadingProfile().isDoThreading();
    }

    public String getConnectionDescription() {
        return "endpoint.outbound." + this.endpoint.getEndpointURI().toString();
    }

    public final void start() throws MuleException {
        if (!this.connected.get()) {
            this.startOnConnect = true;
            try {
                this.connect();
            }
            catch (Exception e) {
                throw new LifecycleException(e, (Object)this);
            }
            return;
        }
        if (this.started.compareAndSet(false, true)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Starting: " + this));
            }
            this.doStart();
        }
    }

    public final void stop() {
        try {
            if (this.connected.get()) {
                this.disconnect();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (this.started.compareAndSet(true, false)) {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Stopping: " + this));
                }
                this.doStop();
            }
            catch (MuleException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void doInitialise() throws InitialisationException {
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    protected void doStart() throws MuleException {
    }

    protected void doStop() throws MuleException {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(80);
        sb.append(ClassUtils.getSimpleName(this.getClass()));
        sb.append("{this=").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(", endpoint=").append(this.endpoint.getEndpointURI());
        sb.append(", disposed=").append(this.disposed);
        sb.append('}');
        return sb.toString();
    }

    public void setEndpoint(ImmutableEndpoint endpoint) {
        if (endpoint == null) {
            throw new IllegalArgumentException("Endpoint cannot be null");
        }
        this.endpoint = endpoint;
    }

    protected abstract WorkManager getWorkManager();

    public boolean isStarted() {
        return this.started.get();
    }
}

