/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.wire;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transformer.wire.WireFormat;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.IOUtils;

public class TransformerPairWireFormat
implements WireFormat {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected Transformer inboundTransformer;
    protected Transformer outboundTransformer;
    protected Class transferObjectClass;
    protected MuleContext muleContext;

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
        this.inboundTransformer.setMuleContext(this.muleContext);
        this.outboundTransformer.setMuleContext(this.muleContext);
    }

    public Object read(InputStream in) throws MuleException {
        if (this.inboundTransformer == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("inboundTransformer").getMessage());
        }
        if (this.inboundTransformer.isSourceTypeSupported(InputStream.class)) {
            return this.inboundTransformer.transform(in);
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)in, (OutputStream)baos);
            return this.inboundTransformer.transform(baos.toByteArray());
        }
        catch (IOException e) {
            throw new DefaultMuleException(CoreMessages.failedToReadPayload(), (Throwable)e);
        }
    }

    public void write(OutputStream out, Object o, String encoding) throws MuleException {
        block6: {
            if (this.outboundTransformer == null) {
                throw new IllegalArgumentException(CoreMessages.objectIsNull("outboundTransformer").getMessage());
            }
            try {
                Class returnClass = this.outboundTransformer.getReturnClass();
                if (returnClass == null) {
                    this.logger.warn((Object)("No return class was set on transformer: " + this.outboundTransformer + ". Attempting to work out how to treat the result transformation"));
                    Object result = this.outboundTransformer.transform(o);
                    byte[] bytes = result instanceof byte[] ? (byte[])result : result.toString().getBytes(encoding);
                    out.write(bytes);
                    break block6;
                }
                if (returnClass.equals(byte[].class)) {
                    byte[] b = (byte[])this.outboundTransformer.transform(o);
                    out.write(b);
                    break block6;
                }
                if (returnClass.equals(String.class)) {
                    String s = (String)this.outboundTransformer.transform(o);
                    out.write(s.getBytes(encoding));
                    break block6;
                }
                throw new TransformerException(CoreMessages.transformFailedFrom(o.getClass()));
            }
            catch (IOException e) {
                throw new TransformerException(CoreMessages.transformFailedFrom(o.getClass()), (Throwable)e);
            }
        }
    }

    public Transformer getInboundTransformer() {
        return this.inboundTransformer;
    }

    public void setInboundTransformer(Transformer inboundTransformer) {
        this.inboundTransformer = inboundTransformer;
    }

    public Transformer getOutboundTransformer() {
        return this.outboundTransformer;
    }

    public void setOutboundTransformer(Transformer outboundTransformer) {
        this.outboundTransformer = outboundTransformer;
    }

    public void setTransferObjectClass(Class clazz) {
        this.transferObjectClass = clazz;
    }
}

