/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.context.MuleContextAware;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractMessageAwareTransformer;

public class MessagePropertiesTransformer
extends AbstractMessageAwareTransformer
implements MuleContextAware {
    private List deleteProperties = null;
    private Map addProperties = null;
    private Map renameProperties;
    private boolean overwrite = true;
    private MuleContext muleContext;

    public MessagePropertiesTransformer() {
        this.registerSourceType(Object.class);
        this.setReturnClass(Object.class);
    }

    public Object clone() throws CloneNotSupportedException {
        MessagePropertiesTransformer clone = (MessagePropertiesTransformer)super.clone();
        if (this.deleteProperties != null) {
            clone.setDeleteProperties(new ArrayList(this.deleteProperties));
        }
        if (this.addProperties != null) {
            clone.setAddProperties(new HashMap(this.addProperties));
        }
        if (this.renameProperties != null) {
            clone.setRenameProperties(new HashMap(this.renameProperties));
        }
        return clone;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public Object transform(MuleMessage message, String outputEncoding) throws TransformerException {
        Object value;
        String key;
        Set<String> propertyNames;
        if (this.deleteProperties != null && this.deleteProperties.size() > 0) {
            Iterator iterator = this.deleteProperties.iterator();
            while (iterator.hasNext()) {
                message.removeProperty(iterator.next().toString());
            }
        }
        if (this.addProperties != null && this.addProperties.size() > 0) {
            propertyNames = message.getPropertyNames();
            for (Map.Entry entry : this.addProperties.entrySet()) {
                if (entry.getKey() == null) {
                    this.logger.error((Object)"Setting Null property keys is not supported, this entry is being ignored");
                    continue;
                }
                key = entry.getKey().toString();
                value = entry.getValue();
                if (this.muleContext.getExpressionManager().isValidExpression(value.toString())) {
                    value = this.muleContext.getExpressionManager().evaluate(value.toString(), message);
                }
                if (this.overwrite) {
                    if (this.logger.isDebugEnabled() && propertyNames.contains(key)) {
                        this.logger.debug((Object)("Overwriting message property " + key));
                    }
                    message.setProperty(key, value);
                    continue;
                }
                if (propertyNames.contains(key)) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)MessageFormat.format("Message already contains the property and overwrite is false, skipping: key={0}, value={1}", key, value));
                    continue;
                }
                message.setProperty(key, value);
            }
        }
        if (this.renameProperties != null && this.renameProperties.size() > 0) {
            propertyNames = message.getPropertyNames();
            for (Map.Entry entry : this.renameProperties.entrySet()) {
                Object temp;
                if (entry.getKey() == null) {
                    this.logger.error((Object)"Setting Null property keys is not supported, this entry is being ignored");
                    continue;
                }
                key = entry.getKey().toString();
                value = (String)entry.getValue();
                if (value == null) {
                    this.logger.error((Object)"Setting Null property values for renameProperties is not supported, this entry is being ignored");
                    continue;
                }
                if (this.muleContext.getExpressionManager().isValidExpression((String)value) && (temp = this.muleContext.getExpressionManager().evaluate(((String)value).toString(), message)) != null) {
                    value = temp.toString();
                }
                if (this.logger.isDebugEnabled() && !propertyNames.contains(key)) {
                    this.logger.debug((Object)("renaming message property " + key + " to " + (String)value));
                }
                Object propValue = message.getProperty(key);
                message.removeProperty(key);
                message.setProperty((String)value, propValue);
            }
        }
        return message;
    }

    public List getDeleteProperties() {
        return this.deleteProperties;
    }

    public void setDeleteProperties(List deleteProperties) {
        this.deleteProperties = deleteProperties;
    }

    public Map getAddProperties() {
        return this.addProperties;
    }

    public void setAddProperties(Map addProperties) {
        this.addProperties = addProperties;
    }

    public Map getRenameProperties() {
        return this.renameProperties;
    }

    public void setRenameProperties(Map renameProperties) {
        this.renameProperties = renameProperties;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }
}

