/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.commons.lang.SerializationUtils;
import org.mule.api.MuleContext;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.AbstractTransformer;
import org.mule.util.store.DeserializationPostInitialisable;

public class ByteArrayToSerializable
extends AbstractTransformer
implements DiscoverableTransformer {
    private int priorityWeighting = 2;

    public ByteArrayToSerializable() {
        this.registerSourceType(byte[].class);
        this.registerSourceType(InputStream.class);
    }

    public Object doTransform(Object src, String encoding) throws TransformerException {
        try {
            final Object result = src instanceof byte[] ? SerializationUtils.deserialize((byte[])((byte[])src)) : SerializationUtils.deserialize((InputStream)((InputStream)src));
            if (result instanceof DeserializationPostInitialisable) {
                try {
                    final Method m = result.getClass().getDeclaredMethod("initAfterDeserialisation", MuleContext.class);
                    Object o = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            try {
                                m.setAccessible(true);
                                m.invoke(result, ByteArrayToSerializable.this.muleContext);
                                return null;
                            }
                            catch (Exception e) {
                                return e;
                            }
                        }
                    });
                    if (o != null) {
                        throw (Exception)o;
                    }
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalArgumentException("Object " + result.getClass() + " implements " + DeserializationPostInitialisable.class + " but does not have a method " + "private void initAfterDeserialisation(MuleContext) defined", e);
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new TransformerException(CoreMessages.transformFailed("byte[]", "Object"), this, (Throwable)e);
        }
    }

    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    public void setPriorityWeighting(int priorityWeighting) {
        this.priorityWeighting = priorityWeighting;
    }
}

