/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.compression;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang.SerializationUtils;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.MessageFactory;
import org.mule.transformer.compression.AbstractCompressionTransformer;
import org.mule.util.IOUtils;
import org.mule.util.compression.GZipCompression;

public class GZipUncompressTransformer
extends AbstractCompressionTransformer {
    public GZipUncompressTransformer() {
        this.setStrategy(new GZipCompression());
        this.registerSourceType(byte[].class);
        this.registerSourceType(InputStream.class);
        this.setReturnClass(byte[].class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doTransform(Object src, String encoding) throws TransformerException {
        byte[] buffer;
        try {
            byte[] input;
            block6: {
                input = null;
                if (src instanceof InputStream) {
                    InputStream inputStream = (InputStream)src;
                    try {
                        input = IOUtils.toByteArray(inputStream);
                        Object var7_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_7 = null;
                        inputStream.close();
                        throw throwable;
                    }
                    inputStream.close();
                    {
                        break block6;
                    }
                }
                input = (byte[])src;
            }
            buffer = this.getStrategy().uncompressByteArray(input);
        }
        catch (IOException e) {
            throw new TransformerException(MessageFactory.createStaticMessage("Failed to uncompress message."), this, (Throwable)e);
        }
        if (!this.getReturnClass().equals(byte[].class)) {
            return SerializationUtils.deserialize((byte[])buffer);
        }
        return buffer;
    }
}

