/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractMessageAwareTransformer;

public class TransformerChain
extends AbstractMessageAwareTransformer {
    private List<Transformer> transformers;

    public TransformerChain(Transformer ... transformers) {
        if (transformers.length < 1) {
            throw new IllegalArgumentException("You must set at least one transformer");
        }
        this.transformers = new LinkedList<Transformer>(Arrays.asList(transformers));
    }

    public TransformerChain(String name, Transformer ... transformers) {
        this.name = name;
        if (transformers.length < 1) {
            throw new IllegalArgumentException("You must set at least one transformer");
        }
        this.transformers = new LinkedList<Transformer>(Arrays.asList(transformers));
    }

    public Object transform(MuleMessage message, String outputEncoding) throws TransformerException {
        MuleMessage result = message;
        Object temp = message;
        Transformer lastTransformer2 = null;
        for (Transformer lastTransformer2 : this.transformers) {
            temp = lastTransformer2.transform(temp);
            if (temp instanceof MuleMessage) {
                result = (MuleMessage)temp;
                continue;
            }
            result.setPayload(temp);
        }
        if (lastTransformer2 != null && lastTransformer2.getReturnClass().equals(MuleMessage.class)) {
            return result;
        }
        return result.getPayload();
    }

    public void initialise() throws InitialisationException {
        for (Transformer transformer : this.transformers) {
            transformer.initialise();
        }
    }

    public void setMuleContext(MuleContext muleContext) {
        super.setMuleContext(muleContext);
        for (Transformer transformer : this.transformers) {
            transformer.setMuleContext(muleContext);
        }
    }

    public void setEndpoint(ImmutableEndpoint endpoint) {
        super.setEndpoint(endpoint);
        for (Transformer transformer : this.transformers) {
            transformer.setEndpoint(endpoint);
        }
    }
}

