/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.inbound;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.routing.InboundRouter;
import org.mule.api.routing.MessageInfoMapping;
import org.mule.api.routing.RoutingException;
import org.mule.api.routing.filter.Filter;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.AbstractRouter;
import org.mule.routing.MuleMessageInfoMapping;

public class SelectiveConsumer
extends AbstractRouter
implements InboundRouter {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private volatile Filter filter;
    private volatile boolean transformFirst = true;
    private MessageInfoMapping messageInfoMapping = new MuleMessageInfoMapping();

    public boolean isMatch(MuleEvent event) throws MessagingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Attempting to route event: " + event.getId()));
        }
        if (this.filter == null) {
            return true;
        }
        MuleMessage message = event.getMessage();
        if (this.transformFirst) {
            try {
                Object payload = event.transformMessage();
                message = new DefaultMuleMessage(payload, message, this.muleContext);
            }
            catch (TransformerException e) {
                throw new RoutingException(CoreMessages.transformFailedBeforeFilter(), event.getMessage(), event.getEndpoint(), e);
            }
        }
        boolean result = this.filter.accept(message);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("MuleEvent " + event.getId() + (result ? " passed filter " : " did not pass filter ") + this.filter.getClass().getName()));
        }
        return result;
    }

    public MuleEvent[] process(MuleEvent event) throws MessagingException {
        if (this.isMatch(event)) {
            return new MuleEvent[]{event};
        }
        return null;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public boolean isTransformFirst() {
        return this.transformFirst;
    }

    public void setTransformFirst(boolean transformFirst) {
        this.transformFirst = transformFirst;
    }

    public MessageInfoMapping getMessageInfoMapping() {
        return this.messageInfoMapping;
    }

    public void setMessageInfoMapping(MessageInfoMapping messageInfoMapping) {
        this.messageInfoMapping = messageInfoMapping;
    }
}

