/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.inbound;

import javax.resource.spi.work.WorkException;
import org.mule.DefaultMuleEvent;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.routing.EventCorrelator;
import org.mule.routing.EventCorrelatorCallback;
import org.mule.routing.inbound.SelectiveConsumer;

public abstract class AbstractEventAggregator
extends SelectiveConsumer {
    protected EventCorrelator eventCorrelator;
    private int timeout = 0;
    private boolean failOnTimeout = true;

    public void initialise() throws InitialisationException {
        this.eventCorrelator = new EventCorrelator(this.getCorrelatorCallback(), this.getMessageInfoMapping(), this.muleContext);
        if (this.timeout != 0) {
            this.eventCorrelator.setTimeout(this.timeout);
            this.eventCorrelator.setFailOnTimeout(this.isFailOnTimeout());
            try {
                this.eventCorrelator.enableTimeoutMonitor();
            }
            catch (WorkException e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
        super.initialise();
    }

    protected abstract EventCorrelatorCallback getCorrelatorCallback();

    public MuleEvent[] process(MuleEvent event) throws MessagingException {
        MuleMessage msg = this.eventCorrelator.process(event);
        if (msg == null) {
            return null;
        }
        MuleEvent[] result = new MuleEvent[]{new DefaultMuleEvent(msg, event)};
        return result;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean isFailOnTimeout() {
        return this.failOnTimeout;
    }

    public void setFailOnTimeout(boolean failOnTimeout) {
        this.failOnTimeout = failOnTimeout;
    }
}

