/*
 * Decompiled with CFR 0.152.
 */
package org.mule.retry.policies;

import java.io.InterruptedIOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.context.WorkManager;
import org.mule.api.retry.RetryCallback;
import org.mule.api.retry.RetryContext;
import org.mule.api.retry.RetryNotifier;
import org.mule.api.retry.RetryPolicy;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.retry.DefaultRetryContext;
import org.mule.retry.PolicyStatus;
import org.mule.retry.RetryPolicyExhaustedException;
import org.mule.retry.notifiers.ConnectNotifier;

public abstract class AbstractPolicyTemplate
implements RetryPolicyTemplate,
MuleContextAware {
    protected RetryNotifier notifier = new ConnectNotifier();
    private Map metaInfo;
    private MuleContext muleContext;
    protected final transient Log logger = LogFactory.getLog(this.getClass());

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public RetryContext execute(RetryCallback callback, WorkManager workManager) throws Exception {
        Exception cause;
        DefaultRetryContext context;
        block10: {
            DefaultRetryContext defaultRetryContext;
            PolicyStatus status = null;
            RetryPolicy policy = this.createRetryInstance();
            context = new DefaultRetryContext(callback.getWorkDescription());
            context.setMuleContext(this.muleContext);
            if (this.metaInfo != null) {
                context.setMetaInfo(this.metaInfo);
            }
            try {
                cause = null;
                while (true) {
                    try {
                        callback.doWork(context);
                        if (this.notifier == null) break;
                        this.notifier.onSuccess(context);
                    }
                    catch (Exception e) {
                        cause = e;
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)cause);
                        }
                        if (this.notifier != null) {
                            this.notifier.onFailure(context, cause);
                        }
                        if (!(cause instanceof InterruptedException) && !(cause instanceof InterruptedIOException)) continue;
                        this.logger.error((Object)"Process was interrupted (InterruptedException), ceasing process");
                        break;
                        if ((status = policy.applyPolicy(cause)).isOk()) continue;
                    }
                    break;
                }
                if (status != null && !status.isOk()) break block10;
                defaultRetryContext = context;
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                block11: {
                    Object var9_10 = null;
                    if (status == null || status.getThrowable() == null || !this.logger.isDebugEnabled()) break block11;
                    this.logger.debug((Object)status.getThrowable());
                }
                throw throwable;
            }
            if (status != null && status.getThrowable() != null && this.logger.isDebugEnabled()) {
                this.logger.debug((Object)status.getThrowable());
            }
            return defaultRetryContext;
        }
        context.setFailed(cause);
        throw new RetryPolicyExhaustedException(cause, (Object)callback.getWorkDescription());
    }

    public RetryNotifier getNotifier() {
        return this.notifier;
    }

    public void setNotifier(RetryNotifier retryNotifier) {
        this.notifier = retryNotifier;
    }

    public Map getMetaInfo() {
        return this.metaInfo;
    }

    public void setMetaInfo(Map metaInfo) {
        this.metaInfo = metaInfo;
    }

    public void setId(String id) {
    }
}

