/*
 * Decompiled with CFR 0.152.
 */
package org.mule.model.seda;

import java.text.MessageFormat;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkListener;
import org.apache.commons.lang.BooleanUtils;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.FailedToQueueEventException;
import org.mule.OptimizedRequestContext;
import org.mule.RequestContext;
import org.mule.api.ExceptionPayload;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.context.WorkManager;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.service.ServiceException;
import org.mule.api.transport.MessageAdapter;
import org.mule.api.transport.ReplyToHandler;
import org.mule.config.ChainedThreadingProfile;
import org.mule.config.QueueProfile;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.management.stats.ServiceStatistics;
import org.mule.message.DefaultExceptionPayload;
import org.mule.model.seda.SedaModel;
import org.mule.service.AbstractService;
import org.mule.transport.NullPayload;
import org.mule.util.queue.Queue;
import org.mule.util.queue.QueueSession;

public class SedaService
extends AbstractService
implements Work,
WorkListener {
    private static final long serialVersionUID = 7711976708670893015L;
    private static final String QUEUE_NAME_SUFFIX = ".service";
    protected WorkManager workManager;
    protected Integer queueTimeout;
    protected ThreadingProfile threadingProfile;
    protected QueueProfile queueProfile;
    protected Queue queue;
    private final Object queueStatsGuard = new Object();

    protected synchronized void doInitialise() throws InitialisationException {
        if (this.threadingProfile == null) {
            this.threadingProfile = this.muleContext.getDefaultServiceThreadingProfile();
        }
        ChainedThreadingProfile threadingProfile = new ChainedThreadingProfile(this.threadingProfile);
        threadingProfile.setMaxThreadsActive(threadingProfile.getMaxThreadsActive() + 1);
        this.workManager = threadingProfile.createWorkManager(this.getName(), this.muleContext.getConfiguration().getShutdownTimeout());
        if (this.queueProfile == null) {
            this.queueProfile = ((SedaModel)this.model).getQueueProfile();
        }
        if (this.queueTimeout == null) {
            this.setQueueTimeout(((SedaModel)this.model).getQueueTimeout());
        }
        try {
            if (this.name == null) {
                throw new InitialisationException(MessageFactory.createStaticMessage("Service has no name to identify it"), (Initialisable)this);
            }
            this.queueProfile.configureQueue(this.getQueueName(), this.muleContext.getQueueManager());
            this.queue = this.muleContext.getQueueManager().getQueueSession().getQueue(this.getQueueName());
            if (this.queue == null) {
                throw new InitialisationException(MessageFactory.createStaticMessage("Queue not created for service " + this.name), (Initialisable)this);
            }
        }
        catch (InitialisationException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InitialisationException(CoreMessages.objectFailedToInitialise("Service Queue"), e, this);
        }
    }

    protected void doForceStop() throws MuleException {
        this.doStop();
    }

    protected void doStop() throws MuleException {
        if (this.isPaused()) {
            this.paused.set(false);
        }
        if (this.queue != null && this.queue.size() > 0) {
            try {
                this.stopping.whenFalse(null);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.workManager.dispose();
    }

    protected void doStart() throws MuleException {
        try {
            this.workManager.start();
            this.workManager.scheduleWork(this, Long.MAX_VALUE, null, this);
        }
        catch (Exception e) {
            throw new LifecycleException(CoreMessages.failedToStart("Service: " + this.name), e, this);
        }
    }

    protected void doDispose() {
        this.queue = null;
        if (this.workManager != null) {
            this.workManager.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDispatch(MuleEvent event) throws MuleException {
        block8: {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)MessageFormat.format("Service: {0} has received asynchronous event on: {1}", this.name, event.getEndpoint().getEndpointURI()));
            }
            try {
                if (this.stats.isEnabled()) {
                    this.enqueue(event);
                    Object object = this.queueStatsGuard;
                    synchronized (object) {
                        this.stats.incQueuedEvent();
                        break block8;
                    }
                }
                this.enqueue(event);
            }
            catch (Exception e) {
                FailedToQueueEventException e1 = new FailedToQueueEventException(CoreMessages.interruptedQueuingEventFor(this.getName()), event.getMessage(), this, e);
                this.handleException(e1);
            }
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("MuleEvent added to queue for: " + this.name));
        }
    }

    protected MuleMessage doSend(MuleEvent event) throws MuleException {
        MessageAdapter result = null;
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)MessageFormat.format("{0} : got proxy for {1} = {2}", this, event.getId(), this.component));
            }
            Object replyTo = event.getMessage().getReplyTo();
            ReplyToHandler replyToHandler = this.getReplyToHandler(event.getMessage(), (InboundEndpoint)event.getEndpoint());
            event.getMessage().setReplyTo(null);
            result = this.invokeComponent(event);
            result = this.sendToOutboundRouter(event, (MuleMessage)result);
            result = this.processAsyncReplyRouter((MuleMessage)result);
            if (result != null && !BooleanUtils.toBoolean((String)((String)result.getProperty("MULE_REPLYTO_STOP")))) {
                this.processReplyTo(event, (MuleMessage)result, replyToHandler, replyTo);
            }
        }
        catch (Exception e) {
            ExceptionPayload exceptionPayload;
            event.getSession().setValid(false);
            if (e instanceof MessagingException) {
                this.handleException(e);
            } else {
                this.handleException(new MessagingException(CoreMessages.eventProcessingFailedFor(this.getName()), event.getMessage(), e));
            }
            if (result == null) {
                result = new DefaultMuleMessage((Object)NullPayload.getInstance(), RequestContext.getEvent().getMessage(), this.muleContext);
            }
            if ((exceptionPayload = result.getExceptionPayload()) == null) {
                exceptionPayload = new DefaultExceptionPayload(e);
            }
            result.setExceptionPayload(exceptionPayload);
        }
        return result;
    }

    public int getQueueSize() {
        if (this.queue == null) {
            this.logger.warn((Object)new InitialisationException(MessageFactory.createStaticMessage("Queue not created for service " + this.name), (Initialisable)this));
            return -1;
        }
        return this.queue.size();
    }

    private String getQueueName() {
        return this.name + QUEUE_NAME_SUFFIX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        DefaultMuleEvent event = null;
        QueueSession queueSession = this.muleContext.getQueueManager().getQueueSession();
        while (!this.stopped.get()) {
            try {
                if (this.paused.get()) {
                    this.paused.whenFalse(null);
                    if (this.stopping.get()) {
                        if (!this.isPersistent() && queueSession != null && this.getQueueSize() > 0) {
                            this.logger.warn((Object)CoreMessages.stopPausedSedaServiceNonPeristentQueueMessageLoss(this.getQueueSize(), this));
                        }
                        this.stopping.set(false);
                        break;
                    }
                }
                if (this.stopping.get() && (this.isPersistent() || queueSession == null || this.getQueueSize() <= 0)) {
                    this.stopping.set(false);
                    break;
                }
                if (this.stats.isEnabled()) {
                    event = (DefaultMuleEvent)this.dequeue();
                    if (event != null) {
                        Object object = this.queueStatsGuard;
                        synchronized (object) {
                            this.stats.decQueuedEvent();
                        }
                    }
                } else {
                    event = (DefaultMuleEvent)this.dequeue();
                }
                if (event == null) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)MessageFormat.format("Service: {0} dequeued event on: {1}", this.name, event.getEndpoint().getEndpointURI()));
                }
                ComponentStageWorker work = new ComponentStageWorker(event);
                if (this.threadingProfile.isDoThreading()) {
                    this.workManager.scheduleWork(work, Long.MAX_VALUE, null, this);
                    continue;
                }
                work.run();
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    this.stopping.set(false);
                    break;
                }
                if (e instanceof MuleException) {
                    this.handleException(e);
                    continue;
                }
                this.handleException(new ServiceException(CoreMessages.eventProcessingFailedFor(this.name), event == null ? null : event.getMessage(), this, e));
            }
        }
    }

    protected boolean isPersistent() {
        return this.queueProfile.isPersistent();
    }

    public void release() {
        this.stopping.set(false);
    }

    protected void enqueue(MuleEvent event) throws Exception {
        if (this.queue == null) {
            throw new InitialisationException(MessageFactory.createStaticMessage("Queue not created for service " + this.name), (Initialisable)this);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)MessageFormat.format("Service {0} putting event on queue {1}: {2}", this.name, this.queue.getName(), event));
        }
        this.queue.put(event);
    }

    protected MuleEvent dequeue() throws Exception {
        if (this.queue == null) {
            throw new InitialisationException(MessageFactory.createStaticMessage("Queue not created for service " + this.name), (Initialisable)this);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)MessageFormat.format("Service {0} polling queue {1}, timeout = {2}", this.name, this.queue.getName(), this.queueTimeout));
        }
        if (this.getQueueTimeout() == null) {
            throw new InitialisationException(CoreMessages.noServiceQueueTimeoutSet(this), (Initialisable)this);
        }
        return (MuleEvent)this.queue.poll(this.getQueueTimeout().intValue());
    }

    public void workAccepted(WorkEvent event) {
        this.handleWorkException(event, "workAccepted");
    }

    public void workRejected(WorkEvent event) {
        this.handleWorkException(event, "workRejected");
    }

    public void workStarted(WorkEvent event) {
        this.handleWorkException(event, "workStarted");
    }

    public void workCompleted(WorkEvent event) {
        this.handleWorkException(event, "workCompleted");
    }

    protected void handleWorkException(WorkEvent event, String type) {
        if (event == null || event.getException() == null) {
            return;
        }
        Throwable e = event.getException();
        if (event.getException().getCause() != null) {
            e = event.getException().getCause();
        }
        this.logger.error((Object)("Work caused exception on '" + type + "'. Work being executed was: " + event.getWork().toString()));
        if (!(e instanceof Exception)) {
            throw new MuleRuntimeException(CoreMessages.componentCausedErrorIs(this.getName()), e);
        }
        this.handleException((Exception)e);
    }

    protected ServiceStatistics createStatistics() {
        return new ServiceStatistics(this.getName(), this.threadingProfile.getMaxThreadsActive());
    }

    public Object getInstance() throws MuleException {
        throw new UnsupportedOperationException("Direct access to underlying service object is not allowed in the SedaModel.  If this is for a unit test, make sure you are using the TestSedaModel ('seda-test')");
    }

    public QueueProfile getQueueProfile() {
        return this.queueProfile;
    }

    public void setQueueProfile(QueueProfile queueProfile) {
        this.queueProfile = queueProfile;
    }

    public Integer getQueueTimeout() {
        return this.queueTimeout;
    }

    public void setQueueTimeout(Integer queueTimeout) {
        this.queueTimeout = queueTimeout;
    }

    public ThreadingProfile getThreadingProfile() {
        return this.threadingProfile;
    }

    public void setThreadingProfile(ThreadingProfile threadingProfile) {
        this.threadingProfile = threadingProfile;
    }

    public WorkManager getWorkManager() {
        return this.workManager;
    }

    public void setWorkManager(WorkManager workManager) {
        this.workManager = workManager;
    }

    protected void dispatchToOutboundRouter(MuleEvent event, MuleMessage result) throws MessagingException {
        super.dispatchToOutboundRouter(event, result);
    }

    private class ComponentStageWorker
    implements Work {
        private MuleEvent event;

        public ComponentStageWorker(MuleEvent event) {
            this.event = event;
        }

        public void run() {
            try {
                this.event = OptimizedRequestContext.criticalSetEvent(this.event);
                Object replyTo = this.event.getMessage().getReplyTo();
                ReplyToHandler replyToHandler = SedaService.this.getReplyToHandler(this.event.getMessage(), (InboundEndpoint)this.event.getEndpoint());
                this.event.getMessage().setReplyTo(null);
                MuleMessage result = SedaService.this.invokeComponent(this.event);
                SedaService.this.dispatchToOutboundRouter(this.event, result);
                SedaService.this.processReplyTo(this.event, result, replyToHandler, replyTo);
            }
            catch (Exception e) {
                this.event.getSession().setValid(false);
                if (e instanceof MessagingException) {
                    SedaService.this.handleException(e);
                }
                SedaService.this.handleException(new MessagingException(CoreMessages.eventProcessingFailedFor(SedaService.this.getName()), this.event.getMessage(), e));
            }
        }

        public void release() {
        }
    }
}

