/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import java.util.HashMap;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionEvaluator;
import org.mule.api.expression.RequiredValueException;
import org.mule.config.i18n.CoreMessages;
import org.mule.expression.ExpressionConstants;

public class MessageAttachmentsExpressionEvaluator
implements ExpressionEvaluator,
ExpressionConstants {
    public static final String NAME = "attachments";

    public Object evaluate(String expression, MuleMessage message) {
        HashMap<String, DataHandler> result;
        if ("*".equals(expression)) {
            result = new HashMap<String, DataHandler>(message.getAttachmentNames().size());
            for (String name : message.getAttachmentNames()) {
                result.put(name, message.getAttachment(name));
            }
        } else {
            if ("{count}".equals(expression)) {
                return message.getAttachmentNames().size();
            }
            StringTokenizer tokenizer = new StringTokenizer(expression, ",");
            result = new HashMap(tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                boolean required;
                String s = tokenizer.nextToken();
                if ((s = s.trim()).endsWith("*")) {
                    s = s.substring(0, s.length() - "*".length());
                    required = false;
                } else {
                    required = true;
                }
                DataHandler val = message.getAttachment(s);
                if (val != null) {
                    result.put(s, val);
                    continue;
                }
                if (!required) continue;
                throw new RequiredValueException(CoreMessages.expressionEvaluatorReturnedNull(NAME, expression));
            }
        }
        if (result.size() == 0) {
            return null;
        }
        return result;
    }

    public String getName() {
        return NAME;
    }

    public void setName(String name) {
        throw new UnsupportedOperationException();
    }
}

