/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.util.Collection;
import javax.resource.spi.work.WorkListener;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.context.MuleContextAware;
import org.mule.api.context.WorkManager;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleManager;
import org.mule.api.registry.MuleRegistry;
import org.mule.api.registry.RegistrationException;
import org.mule.api.registry.Registry;
import org.mule.api.registry.RegistryBroker;
import org.mule.api.security.SecurityManager;
import org.mule.api.transaction.TransactionManagerFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.context.notification.MuleContextNotification;
import org.mule.context.notification.NotificationException;
import org.mule.context.notification.ServerNotificationManager;
import org.mule.expression.DefaultExpressionManager;
import org.mule.management.stats.AllStatistics;
import org.mule.registry.DefaultRegistryBroker;
import org.mule.registry.MuleRegistryHelper;
import org.mule.util.ServerShutdownSplashScreen;
import org.mule.util.ServerStartupSplashScreen;
import org.mule.util.SplashScreen;
import org.mule.util.queue.QueueManager;

public class DefaultMuleContext
implements MuleContext {
    private static transient Log logger = LogFactory.getLog(DefaultMuleContext.class);
    private RegistryBroker registryBroker;
    private MuleRegistry muleRegistryHelper;
    private AllStatistics stats = new AllStatistics();
    private WorkManager workManager;
    private WorkListener workListener;
    protected LifecycleManager lifecycleManager;
    protected ServerNotificationManager notificationManager;
    private MuleConfiguration config;
    private long startDate;
    private ExpressionManager expressionManager;
    private static MuleContext staticInsntace;
    private SplashScreen startupScreen;
    private SplashScreen shutdownScreen;

    public DefaultMuleContext(MuleConfiguration config, WorkManager workManager, WorkListener workListener, LifecycleManager lifecycleManager, ServerNotificationManager notificationManager) {
        this.config = config;
        ((MuleContextAware)((Object)config)).setMuleContext(this);
        this.workManager = workManager;
        this.workListener = workListener;
        this.lifecycleManager = lifecycleManager;
        this.notificationManager = notificationManager;
        this.notificationManager.setMuleContext(this);
        this.expressionManager = new DefaultExpressionManager();
        staticInsntace = this;
    }

    public static MuleContext getContext() {
        return staticInsntace;
    }

    protected RegistryBroker createRegistryBroker() {
        return new DefaultRegistryBroker(this);
    }

    protected MuleRegistry createRegistryHelper(Registry registry) {
        return new MuleRegistryHelper(registry);
    }

    public void setSplash(SplashScreen startup, SplashScreen shutdown) {
        if (this.isInitialised()) {
            return;
        }
        this.startupScreen = startup;
        this.shutdownScreen = shutdown;
    }

    protected void initSplashScreens() {
        if (this.startupScreen == null) {
            this.startupScreen = SplashScreen.getInstance(ServerStartupSplashScreen.class);
        }
        if (this.shutdownScreen == null) {
            this.shutdownScreen = SplashScreen.getInstance(ServerShutdownSplashScreen.class);
        }
        this.startupScreen.setHeader(this);
        this.startupScreen.setFooter(this);
        this.shutdownScreen.setHeader(this);
        this.shutdownScreen.setFooter(this);
    }

    public synchronized void initialise() throws InitialisationException {
        if (this.isInitialised()) {
            return;
        }
        this.lifecycleManager.checkPhase("initialise");
        if (this.getNotificationManager() == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull("_muleNotificationManager"));
        }
        if (this.workManager == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull("workManager"));
        }
        try {
            this.registryBroker = this.createRegistryBroker();
            this.muleRegistryHelper = this.createRegistryHelper(this.registryBroker);
            this.registryBroker.initialise();
            this.workManager.start();
            this.getNotificationManager().start(this.workManager, this.workListener);
            this.fireNotification(new MuleContextNotification((MuleContext)this, 101));
            this.lifecycleManager.firePhase(this, "initialise");
            this.fireNotification(new MuleContextNotification((MuleContext)this, 102));
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public synchronized void start() throws MuleException {
        this.lifecycleManager.checkPhase("start");
        if (!this.isStarted()) {
            if (this.getSecurityManager() == null) {
                throw new MuleRuntimeException(CoreMessages.objectIsNull("securityManager"));
            }
            if (this.getQueueManager() == null) {
                throw new MuleRuntimeException(CoreMessages.objectIsNull("queueManager"));
            }
            this.startDate = System.currentTimeMillis();
            this.fireNotification(new MuleContextNotification((MuleContext)this, 103));
            this.lifecycleManager.firePhase(this, "start");
            this.fireNotification(new MuleContextNotification((MuleContext)this, 104));
            if (logger.isInfoEnabled()) {
                SplashScreen splashScreen = SplashScreen.getInstance(ServerStartupSplashScreen.class);
                splashScreen.setHeader(this);
                splashScreen.setFooter(this);
                logger.info((Object)splashScreen.toString());
            }
        }
    }

    public synchronized void stop() throws MuleException {
        this.lifecycleManager.checkPhase("stop");
        this.fireNotification(new MuleContextNotification((MuleContext)this, 105));
        this.lifecycleManager.firePhase(this, "stop");
        this.fireNotification(new MuleContextNotification((MuleContext)this, 106));
    }

    public synchronized void dispose() {
        if (this.isDisposed()) {
            return;
        }
        ServerNotificationManager notificationManager = this.getNotificationManager();
        this.lifecycleManager.checkPhase("dispose");
        this.fireNotification(new MuleContextNotification((MuleContext)this, 107));
        try {
            if (this.isStarted()) {
                this.stop();
            }
        }
        catch (MuleException e) {
            logger.error((Object)("Failed to stop manager: " + e.getMessage()), (Throwable)e);
        }
        try {
            this.lifecycleManager.firePhase(this, "dispose");
            this.registryBroker.dispose();
        }
        catch (Exception e) {
            logger.debug((Object)("Failed to cleanly dispose Mule: " + e.getMessage()), (Throwable)e);
        }
        notificationManager.fireNotification(new MuleContextNotification((MuleContext)this, 108));
        notificationManager.dispose();
        this.workManager.dispose();
        if (this.getStartDate() > 0L && logger.isInfoEnabled()) {
            SplashScreen splashScreen = SplashScreen.getInstance(ServerShutdownSplashScreen.class);
            splashScreen.setHeader(this);
            logger.info((Object)splashScreen.toString());
        }
        staticInsntace = null;
        SplashScreen.dispose();
    }

    public boolean isInitialised() {
        return this.lifecycleManager.isPhaseComplete("initialise");
    }

    public boolean isInitialising() {
        return "dispose".equals(this.lifecycleManager.getExecutingPhase());
    }

    protected boolean isStopped() {
        return this.lifecycleManager.isPhaseComplete("stop");
    }

    protected boolean isStopping() {
        return "stop".equals(this.lifecycleManager.getExecutingPhase());
    }

    public boolean isStarted() {
        return this.lifecycleManager.isPhaseComplete("start");
    }

    protected boolean isStarting() {
        return "start".equals(this.lifecycleManager.getExecutingPhase());
    }

    public boolean isDisposed() {
        return this.lifecycleManager.isPhaseComplete("dispose");
    }

    public boolean isDisposing() {
        return "dispose".equals(this.lifecycleManager.getExecutingPhase());
    }

    public LifecycleManager getLifecycleManager() {
        return this.lifecycleManager;
    }

    public AllStatistics getStatistics() {
        return this.stats;
    }

    public void registerListener(ServerNotificationListener l) throws NotificationException {
        this.registerListener(l, null);
    }

    public void registerListener(ServerNotificationListener l, String resourceIdentifier) throws NotificationException {
        ServerNotificationManager notificationManager = this.getNotificationManager();
        if (notificationManager == null) {
            throw new MuleRuntimeException(CoreMessages.serverNotificationManagerNotEnabled());
        }
        notificationManager.addListenerSubscription(l, resourceIdentifier);
    }

    public void unregisterListener(ServerNotificationListener l) {
        ServerNotificationManager notificationManager = this.getNotificationManager();
        if (notificationManager != null) {
            notificationManager.removeListener(l);
        }
    }

    public void fireNotification(ServerNotification notification) {
        ServerNotificationManager notificationManager = this.getNotificationManager();
        if (notificationManager != null) {
            notificationManager.fireNotification(notification);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("MuleEvent Manager is not enabled, ignoring notification: " + notification));
        }
    }

    public void setSecurityManager(SecurityManager securityManager) throws RegistrationException {
        this.checkLifecycleForPropertySet("_muleSecurityManager", "initialise");
        this.registryBroker.registerObject("_muleSecurityManager", securityManager);
    }

    public SecurityManager getSecurityManager() {
        Collection temp;
        SecurityManager securityManager = (SecurityManager)this.registryBroker.lookupObject("_muleSecurityManager");
        if (securityManager == null && (temp = this.registryBroker.lookupObjects(SecurityManager.class)).size() > 0) {
            securityManager = (SecurityManager)temp.iterator().next();
        }
        return securityManager;
    }

    public WorkManager getWorkManager() {
        return this.workManager;
    }

    public WorkListener getWorkListener() {
        return this.workListener;
    }

    public QueueManager getQueueManager() {
        Collection temp;
        QueueManager queueManager = (QueueManager)this.registryBroker.lookupObject("_muleQueueManager");
        if (queueManager == null && (temp = this.registryBroker.lookupObjects(QueueManager.class)).size() > 0) {
            queueManager = (QueueManager)temp.iterator().next();
        }
        return queueManager;
    }

    public void setQueueManager(QueueManager queueManager) throws RegistrationException {
        this.checkLifecycleForPropertySet("_muleQueueManager", "initialise");
        this.registryBroker.registerObject("_muleQueueManager", queueManager);
    }

    public MuleConfiguration getConfiguration() {
        return this.config;
    }

    public ServerNotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    public void setTransactionManager(TransactionManager manager) throws RegistrationException {
        this.registryBroker.registerObject("_muleTransactionManager", manager);
    }

    public TransactionManager getTransactionManager() {
        TransactionManager transactionManager = (TransactionManager)this.registryBroker.lookupObject("_muleTransactionManager");
        if (transactionManager == null) {
            Collection temp = this.registryBroker.lookupObjects(TransactionManagerFactory.class);
            if (temp.size() > 0) {
                try {
                    transactionManager = ((TransactionManagerFactory)temp.iterator().next()).create(this.config);
                }
                catch (Exception e) {
                    throw new MuleRuntimeException(CoreMessages.failedToCreate("transaction manager"), (Throwable)e);
                }
            } else {
                temp = this.registryBroker.lookupObjects(TransactionManager.class);
                if (temp.size() > 0) {
                    transactionManager = (TransactionManager)temp.iterator().next();
                }
            }
        }
        return transactionManager;
    }

    public void register() throws RegistrationException {
        throw new UnsupportedOperationException("register");
    }

    public void deregister() throws RegistrationException {
        throw new UnsupportedOperationException("deregister");
    }

    public String getRegistryId() {
        throw new UnsupportedOperationException("registryId");
    }

    protected void checkLifecycleForPropertySet(String propertyName, String phase) throws IllegalStateException {
        if (this.lifecycleManager.isPhaseComplete(phase)) {
            throw new IllegalStateException("Cannot set property: '" + propertyName + "' once the server has been gone through the " + phase + " phase.");
        }
    }

    public MuleRegistry getRegistry() {
        return this.muleRegistryHelper;
    }

    public ThreadingProfile getDefaultMessageDispatcherThreadingProfile() {
        return (ThreadingProfile)this.getRegistry().lookupObject("_defaultMessageDispatcherThreadingProfile");
    }

    public ThreadingProfile getDefaultMessageRequesterThreadingProfile() {
        return (ThreadingProfile)this.getRegistry().lookupObject("_defaultMessageRequesterThreadingProfile");
    }

    public ThreadingProfile getDefaultMessageReceiverThreadingProfile() {
        return (ThreadingProfile)this.getRegistry().lookupObject("_defaultMessageReceiverThreadingProfile");
    }

    public ThreadingProfile getDefaultServiceThreadingProfile() {
        return (ThreadingProfile)this.getRegistry().lookupObject("_defaultServiceThreadingProfile");
    }

    public ThreadingProfile getDefaultThreadingProfile() {
        return (ThreadingProfile)this.getRegistry().lookupObject("_defaultThreadingProfile");
    }

    public void addRegistry(long id, Registry registry) {
        this.registryBroker.addRegistry(id, registry);
    }

    public void removeRegistry(long id) {
        this.registryBroker.removeRegistry(id);
    }

    public long getStartDate() {
        return this.startDate;
    }

    public ExpressionManager getExpressionManager() {
        return this.expressionManager;
    }
}

