/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentMap;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicReference;
import java.beans.ExceptionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.mule.DefaultExceptionStrategy;
import org.mule.MuleSessionHandler;
import org.mule.RegistryContext;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.context.WorkManager;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationHandler;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.DisposeException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.registry.ServiceException;
import org.mule.api.retry.RetryCallback;
import org.mule.api.retry.RetryContext;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.api.service.Service;
import org.mule.api.transport.Connectable;
import org.mule.api.transport.Connector;
import org.mule.api.transport.ConnectorException;
import org.mule.api.transport.DispatchException;
import org.mule.api.transport.MessageAdapter;
import org.mule.api.transport.MessageDispatcher;
import org.mule.api.transport.MessageDispatcherFactory;
import org.mule.api.transport.MessageReceiver;
import org.mule.api.transport.MessageRequester;
import org.mule.api.transport.MessageRequesterFactory;
import org.mule.api.transport.ReplyToHandler;
import org.mule.api.transport.SessionHandler;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.context.notification.ConnectionNotification;
import org.mule.context.notification.EndpointMessageNotification;
import org.mule.context.notification.OptimisedNotificationHandler;
import org.mule.lifecycle.AlreadyInitialisedException;
import org.mule.model.streaming.DelegatingInputStream;
import org.mule.retry.policies.NoRetryPolicyTemplate;
import org.mule.routing.filters.WildcardFilter;
import org.mule.transformer.TransformerUtils;
import org.mule.transport.AbstractMessageReceiver;
import org.mule.transport.ConnectException;
import org.mule.transport.DefaultReplyToHandler;
import org.mule.transport.KeyedPoolMessageDispatcherFactoryAdapter;
import org.mule.transport.KeyedPoolMessageRequesterFactoryAdapter;
import org.mule.transport.service.TransportServiceDescriptor;
import org.mule.transport.service.TransportServiceException;
import org.mule.util.BeanUtils;
import org.mule.util.ClassUtils;
import org.mule.util.CollectionUtils;
import org.mule.util.ObjectNameHelper;
import org.mule.util.ObjectUtils;
import org.mule.util.StringUtils;
import org.mule.util.concurrent.NamedThreadFactory;

public abstract class AbstractConnector
implements Connector,
ExceptionListener,
Connectable,
WorkListener {
    public static final int DEFAULT_NUM_CONCURRENT_TX_RECEIVERS = 4;
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected volatile String name;
    protected volatile ExceptionListener exceptionListener;
    protected volatile MessageDispatcherFactory dispatcherFactory;
    protected volatile MessageRequesterFactory requesterFactory;
    protected final GenericKeyedObjectPool dispatchers = new GenericKeyedObjectPool();
    protected final GenericKeyedObjectPool requesters = new GenericKeyedObjectPool();
    protected final ConcurrentMap receivers = new ConcurrentHashMap();
    private volatile ThreadingProfile dispatcherThreadingProfile;
    private volatile ThreadingProfile requesterThreadingProfile;
    private volatile ThreadingProfile receiverThreadingProfile;
    protected volatile boolean createMultipleTransactedReceivers = true;
    protected volatile int numberOfConcurrentTransactedReceivers = 4;
    private RetryPolicyTemplate retryPolicyTemplate;
    private boolean dynamicNotification = false;
    private ServerNotificationHandler cachedNotificationHandler;
    private final List supportedProtocols;
    private final AtomicReference receiverWorkManager = new AtomicReference();
    private final AtomicReference dispatcherWorkManager = new AtomicReference();
    private final AtomicReference requesterWorkManager = new AtomicReference();
    private final AtomicReference scheduler = new AtomicReference();
    protected volatile TransportServiceDescriptor serviceDescriptor;
    protected volatile Properties serviceOverrides;
    protected volatile SessionHandler sessionHandler = new MuleSessionHandler();
    protected MuleContext muleContext;
    protected final AtomicBoolean initialised = new AtomicBoolean(false);
    protected final AtomicBoolean connected = new AtomicBoolean(false);
    protected final AtomicBoolean started = new AtomicBoolean(false);
    protected final AtomicBoolean disposed = new AtomicBoolean(false);
    protected boolean startOnConnect = false;
    private boolean validateConnections = true;

    public AbstractConnector() {
        this.setDynamicNotification(false);
        this.supportedProtocols = new ArrayList();
        this.supportedProtocols.add(this.getProtocol().toLowerCase());
        this.dispatchers.setTestOnBorrow(false);
        this.dispatchers.setTestOnReturn(true);
        this.requesters.setTestOnBorrow(false);
        this.requesters.setTestOnReturn(true);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        if (newName == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("Connector name").toString());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Set Connector name to: " + newName));
        }
        this.name = newName;
    }

    public final synchronized void initialise() throws InitialisationException {
        if (this.initialised.get()) {
            AlreadyInitialisedException e = new AlreadyInitialisedException("Connector '" + this.getProtocol() + "." + this.getName() + "'", (Initialisable)this);
            throw e;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Initialising: " + this));
        }
        if (this.retryPolicyTemplate == null) {
            this.retryPolicyTemplate = (RetryPolicyTemplate)this.muleContext.getRegistry().lookupObject("_defaultRetryPolicyTemplate");
        }
        this.initFromServiceDescriptor();
        this.setMaxDispatchersActive(this.getDispatcherThreadingProfile().getMaxThreadsActive());
        this.setMaxRequestersActive(this.getRequesterThreadingProfile().getMaxThreadsActive());
        this.doInitialise();
        if (this.exceptionListener == null) {
            this.exceptionListener = new DefaultExceptionStrategy();
            ((DefaultExceptionStrategy)this.exceptionListener).setMuleContext(this.muleContext);
            ((DefaultExceptionStrategy)this.exceptionListener).initialise();
        }
        try {
            this.initWorkManagers();
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        this.initialised.set(true);
    }

    public final synchronized void start() throws MuleException {
        ScheduledExecutorService currentScheduler;
        if (this.isStarted()) {
            this.logger.warn((Object)"Attempting to start a connector which is already started");
            return;
        }
        this.checkDisposed();
        if (!this.isConnected()) {
            this.startOnConnect = true;
            try {
                this.connect();
            }
            catch (Exception e) {
                throw new LifecycleException(e, (Object)this);
            }
            return;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Starting: " + this));
        }
        if ((currentScheduler = (ScheduledExecutorService)this.scheduler.get()) == null || currentScheduler.isShutdown()) {
            this.scheduler.set((Object)this.getScheduler());
        }
        this.doStart();
        this.started.set(true);
        if (this.receivers != null) {
            Iterator iterator = this.receivers.values().iterator();
            while (iterator.hasNext()) {
                ArrayList<MuleException> errors = new ArrayList<MuleException>();
                try {
                    MessageReceiver mr = (MessageReceiver)iterator.next();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Starting receiver on endpoint: " + mr.getEndpoint().getEndpointURI()));
                    }
                    mr.start();
                }
                catch (MuleException e) {
                    this.logger.error((Object)e);
                    errors.add(e);
                }
                if (errors.isEmpty()) continue;
                throw (MuleException)errors.get(0);
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Started: " + this));
        }
    }

    public final boolean isStarted() {
        return this.started.get();
    }

    public final synchronized void stop() throws MuleException {
        if (!this.isStarted()) {
            this.logger.warn((Object)"Attempting to stop a connector which is not started");
            return;
        }
        if (this.isDisposed()) {
            return;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Stopping: " + this));
        }
        ((ScheduledExecutorService)this.scheduler.get()).shutdown();
        this.doStop();
        this.started.set(false);
        if (this.receivers != null) {
            for (MessageReceiver mr : this.receivers.values()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Stopping receiver on endpoint: " + mr.getEndpoint().getEndpointURI()));
                }
                mr.stop();
            }
        }
        if (this.isConnected()) {
            try {
                this.disconnect();
            }
            catch (Exception e) {
                this.logger.error((Object)("Failed to disconnect: " + e.getMessage()), (Throwable)e);
            }
        }
        this.scheduler.set(null);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Stopped: " + this));
        }
    }

    public final synchronized void dispose() {
        if (this.isDisposed()) {
            this.logger.warn((Object)"Attempting to dispose a connector which is already disposed");
            return;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Disposing: " + this));
        }
        if (this.isStarted()) {
            try {
                this.stop();
            }
            catch (MuleException e) {
                this.logger.warn((Object)("Failed to stop during shutdown: " + e.getMessage()), (Throwable)e);
            }
        }
        this.disposeReceivers();
        this.disposeDispatchers();
        this.disposeRequesters();
        this.disposeWorkManagers();
        this.doDispose();
        this.disposed.set(true);
        this.initialised.set(false);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Disposed: " + this));
        }
    }

    protected void initWorkManagers() throws MuleException {
        WorkManager newWorkManager;
        if (this.receiverWorkManager.get() == null && this.receiverWorkManager.compareAndSet(null, (Object)(newWorkManager = this.getReceiverThreadingProfile().createWorkManager(this.getName() + ".receiver")))) {
            newWorkManager.start();
        }
        if (this.dispatcherWorkManager.get() == null && this.dispatcherWorkManager.compareAndSet(null, (Object)(newWorkManager = this.getDispatcherThreadingProfile().createWorkManager(this.getName() + ".dispatcher")))) {
            newWorkManager.start();
        }
        if (this.requesterWorkManager.get() == null && this.requesterWorkManager.compareAndSet(null, (Object)(newWorkManager = this.getRequesterThreadingProfile().createWorkManager(this.getName() + ".requester")))) {
            newWorkManager.start();
        }
    }

    protected void disposeWorkManagers() {
        this.logger.debug((Object)"Disposing dispatcher work manager");
        WorkManager workManager = (WorkManager)this.dispatcherWorkManager.get();
        if (workManager != null) {
            workManager.dispose();
        }
        this.dispatcherWorkManager.set(null);
        this.logger.debug((Object)"Disposing requester work manager");
        workManager = (WorkManager)this.requesterWorkManager.get();
        if (workManager != null) {
            workManager.dispose();
        }
        this.requesterWorkManager.set(null);
        this.logger.debug((Object)"Disposing receiver work manager");
        workManager = (WorkManager)this.receiverWorkManager.get();
        if (workManager != null) {
            workManager.dispose();
        }
        this.receiverWorkManager.set(null);
    }

    protected void disposeReceivers() {
        if (this.receivers != null) {
            this.logger.debug((Object)"Disposing Receivers");
            for (MessageReceiver receiver : this.receivers.values()) {
                try {
                    this.destroyReceiver(receiver, receiver.getEndpoint());
                }
                catch (Throwable e) {
                    this.logger.error((Object)("Failed to destroy receiver: " + receiver), e);
                }
            }
            this.receivers.clear();
            this.logger.debug((Object)"Receivers Disposed");
        }
    }

    protected void disposeDispatchers() {
        if (this.dispatchers != null) {
            this.logger.debug((Object)"Disposing Dispatchers");
            this.dispatchers.clear();
            this.logger.debug((Object)"Dispatchers Disposed");
        }
    }

    protected void disposeRequesters() {
        if (this.requesters != null) {
            this.logger.debug((Object)"Disposing Requesters");
            this.requesters.clear();
            this.logger.debug((Object)"Requesters Disposed");
        }
    }

    public boolean isDisposed() {
        return this.disposed.get();
    }

    public void handleException(Exception exception) {
        this.handleException(exception, null);
    }

    public void handleException(Exception exception, Connectable failed) {
        if (this.isConnected() && exception instanceof ConnectException && !(this.retryPolicyTemplate instanceof NoRetryPolicyTemplate)) {
            this.logger.info((Object)"Exception caught is a ConnectException, attempting to reconnect...");
            try {
                try {
                    this.disconnect();
                }
                catch (Exception de) {
                    this.logger.error((Object)de);
                }
                if (this.exceptionListener == null) {
                    throw new MuleRuntimeException(CoreMessages.exceptionOnConnectorNotExceptionListener(this.getName()), (Throwable)exception);
                }
                this.exceptionListener.exceptionThrown(exception);
                HashMap<String, Object> info = new HashMap<String, Object>();
                if (failed instanceof MessageReceiver) {
                    info.put("failedReceiver", ((MessageReceiver)failed).getReceiverKey());
                } else if (failed instanceof MessageDispatcher) {
                    info.put("failedDispatcher", ((MessageDispatcher)failed).getEndpoint());
                } else if (failed instanceof MessageRequester) {
                    info.put("failedRequester", ((MessageRequester)failed).getEndpoint());
                }
                this.retryPolicyTemplate.setMetaInfo(info);
                this.connect();
            }
            catch (Exception e) {
                if (this.exceptionListener == null) {
                    throw new MuleRuntimeException(CoreMessages.exceptionOnConnectorNotExceptionListener(this.getName()), (Throwable)e);
                }
                this.exceptionListener.exceptionThrown(e);
            }
        } else if (this.exceptionListener != null) {
            this.exceptionListener.exceptionThrown(exception);
        } else {
            throw new MuleRuntimeException(CoreMessages.exceptionOnConnectorNotExceptionListener(this.getName()), (Throwable)exception);
        }
    }

    public void exceptionThrown(Exception e) {
        this.handleException(e);
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener listener) {
        this.exceptionListener = listener;
    }

    public MessageDispatcherFactory getDispatcherFactory() {
        return this.dispatcherFactory;
    }

    public void setDispatcherFactory(MessageDispatcherFactory dispatcherFactory) {
        Object poolFactory = dispatcherFactory instanceof KeyedPoolableObjectFactory ? (KeyedPoolableObjectFactory)dispatcherFactory : new KeyedPoolMessageDispatcherFactoryAdapter(dispatcherFactory);
        this.dispatchers.setFactory(poolFactory);
        this.dispatcherFactory = dispatcherFactory;
    }

    public MessageRequesterFactory getRequesterFactory() {
        return this.requesterFactory;
    }

    public void setRequesterFactory(MessageRequesterFactory requesterFactory) {
        Object poolFactory = requesterFactory instanceof KeyedPoolableObjectFactory ? (KeyedPoolableObjectFactory)requesterFactory : new KeyedPoolMessageRequesterFactoryAdapter(requesterFactory);
        this.requesters.setFactory(poolFactory);
        this.requesterFactory = requesterFactory;
    }

    public int getMaxDispatchersActive() {
        return this.dispatchers.getMaxActive();
    }

    public void setMaxDispatchersActive(int maxActive) {
        this.dispatchers.setMaxActive(maxActive);
        this.dispatchers.setMaxIdle(maxActive);
        this.dispatchers.setMaxTotal(20 * maxActive);
    }

    private MessageDispatcher getDispatcher(OutboundEndpoint endpoint) throws MuleException {
        this.checkDisposed();
        if (endpoint == null) {
            throw new IllegalArgumentException("Endpoint must not be null");
        }
        if (!this.supportsProtocol(endpoint.getConnector().getProtocol())) {
            throw new IllegalArgumentException(CoreMessages.connectorSchemeIncompatibleWithEndpointScheme(this.getProtocol(), endpoint.getEndpointURI().toString()).getMessage());
        }
        MessageDispatcher dispatcher = null;
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Borrowing a dispatcher for endpoint: " + endpoint.getEndpointURI()));
            }
            dispatcher = (MessageDispatcher)this.dispatchers.borrowObject((Object)endpoint);
            dispatcher.initialise();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Borrowed a dispatcher for endpoint: " + endpoint.getEndpointURI() + " = " + dispatcher.toString()));
            }
            MessageDispatcher messageDispatcher = dispatcher;
            return messageDispatcher;
        }
        catch (Exception ex) {
            throw new ConnectorException(CoreMessages.connectorCausedError(), this, ex);
        }
        finally {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Borrowed dispatcher: " + ObjectUtils.toString((Object)dispatcher, (String)"null")));
                }
            }
            catch (Exception ex) {
                throw new ConnectorException(CoreMessages.connectorCausedError(), this, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnDispatcher(OutboundEndpoint endpoint, MessageDispatcher dispatcher) {
        if (endpoint != null && dispatcher != null) {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Returning dispatcher for endpoint: " + endpoint.getEndpointURI() + " = " + dispatcher.toString()));
                }
            }
            catch (Exception ex) {
            }
            finally {
                try {
                    this.dispatchers.returnObject((Object)endpoint, (Object)dispatcher);
                }
                catch (Exception e) {
                    this.logger.error((Object)("Failed to dispose dispatcher for endpoint: " + endpoint + ". This will cause a memory leak. Please report to"), (Throwable)e);
                }
            }
        }
    }

    public int getMaxRequestersActive() {
        return this.requesters.getMaxActive();
    }

    public void setMaxRequestersActive(int maxActive) {
        this.requesters.setMaxActive(maxActive);
        this.requesters.setMaxIdle(maxActive);
        this.requesters.setMaxTotal(20 * maxActive);
    }

    private MessageRequester getRequester(InboundEndpoint endpoint) throws MuleException {
        this.checkDisposed();
        if (endpoint == null) {
            throw new IllegalArgumentException("Endpoint must not be null");
        }
        if (!this.supportsProtocol(endpoint.getConnector().getProtocol())) {
            throw new IllegalArgumentException(CoreMessages.connectorSchemeIncompatibleWithEndpointScheme(this.getProtocol(), endpoint.getEndpointURI().toString()).getMessage());
        }
        MessageRequester requester = null;
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Borrowing a requester for endpoint: " + endpoint.getEndpointURI()));
            }
            requester = (MessageRequester)this.requesters.borrowObject((Object)endpoint);
            requester.initialise();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Borrowed a requester for endpoint: " + endpoint.getEndpointURI() + " = " + requester.toString()));
            }
            MessageRequester messageRequester = requester;
            return messageRequester;
        }
        catch (Exception ex) {
            throw new ConnectorException(CoreMessages.connectorCausedError(), this, ex);
        }
        finally {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Borrowed requester: " + ObjectUtils.toString((Object)requester, (String)"null")));
                }
            }
            catch (Exception ex) {
                throw new ConnectorException(CoreMessages.connectorCausedError(), this, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnRequester(InboundEndpoint endpoint, MessageRequester requester) {
        if (endpoint != null && requester != null) {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Returning requester for endpoint: " + endpoint.getEndpointURI() + " = " + requester.toString()));
                }
            }
            catch (Exception ex) {
            }
            finally {
                try {
                    this.requesters.returnObject((Object)endpoint, (Object)requester);
                }
                catch (Exception e) {
                    this.logger.error((Object)("Failed to dispose requester for endpoint: " + endpoint + ". This will cause a memory leak. Please report to"), (Throwable)e);
                }
            }
        }
    }

    protected void checkDisposed() throws DisposeException {
        if (this.isDisposed()) {
            throw new DisposeException(CoreMessages.cannotUseDisposedConnector(), (Disposable)this);
        }
    }

    public MessageReceiver registerListener(Service service, InboundEndpoint endpoint) throws Exception {
        if (endpoint == null) {
            throw new IllegalArgumentException("The endpoint cannot be null when registering a listener");
        }
        if (service == null) {
            throw new IllegalArgumentException("The service cannot be null when registering a listener");
        }
        EndpointURI endpointUri = endpoint.getEndpointURI();
        if (endpointUri == null) {
            throw new ConnectorException(CoreMessages.endpointIsNullForListener(), this);
        }
        this.logger.info((Object)("Registering listener: " + service.getName() + " on endpointUri: " + endpointUri.toString()));
        if (this.getReceiver(service, endpoint) != null) {
            throw new ConnectorException(CoreMessages.listenerAlreadyRegistered(endpointUri), this);
        }
        MessageReceiver receiver = this.createReceiver(service, endpoint);
        Object receiverKey = this.getReceiverKey(service, endpoint);
        receiver.setReceiverKey(receiverKey.toString());
        receiver.initialise();
        this.receivers.put(receiverKey, (Object)receiver);
        return receiver;
    }

    protected Object getReceiverKey(Service service, InboundEndpoint endpoint) {
        return StringUtils.defaultIfEmpty((String)endpoint.getEndpointURI().getFilterAddress(), (String)endpoint.getEndpointURI().getAddress());
    }

    public final void unregisterListener(Service service, InboundEndpoint endpoint) throws Exception {
        MessageReceiver receiver;
        if (service == null) {
            throw new IllegalArgumentException("The service must not be null when you unregister a listener");
        }
        if (endpoint == null) {
            throw new IllegalArgumentException("The endpoint must not be null when you unregister a listener");
        }
        EndpointURI endpointUri = endpoint.getEndpointURI();
        if (endpointUri == null) {
            throw new IllegalArgumentException("The endpointUri must not be null when you unregister a listener");
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Removing listener on endpointUri: " + endpointUri));
        }
        if (this.receivers != null && !this.receivers.isEmpty() && (receiver = (MessageReceiver)this.receivers.remove(this.getReceiverKey(service, endpoint))) != null) {
            this.destroyReceiver(receiver, endpoint);
            receiver.dispose();
        }
    }

    public ThreadingProfile getDispatcherThreadingProfile() {
        if (this.dispatcherThreadingProfile == null && this.muleContext != null) {
            this.dispatcherThreadingProfile = this.muleContext.getDefaultMessageDispatcherThreadingProfile();
        }
        return this.dispatcherThreadingProfile;
    }

    public void setDispatcherThreadingProfile(ThreadingProfile dispatcherThreadingProfile) {
        this.dispatcherThreadingProfile = dispatcherThreadingProfile;
    }

    public ThreadingProfile getRequesterThreadingProfile() {
        if (this.requesterThreadingProfile == null && this.muleContext != null) {
            this.requesterThreadingProfile = this.muleContext.getDefaultMessageRequesterThreadingProfile();
        }
        return this.requesterThreadingProfile;
    }

    public void setRequesterThreadingProfile(ThreadingProfile requesterThreadingProfile) {
        this.requesterThreadingProfile = requesterThreadingProfile;
    }

    public ThreadingProfile getReceiverThreadingProfile() {
        if (this.receiverThreadingProfile == null && this.muleContext != null) {
            this.receiverThreadingProfile = this.muleContext.getDefaultMessageReceiverThreadingProfile();
        }
        return this.receiverThreadingProfile;
    }

    public void setReceiverThreadingProfile(ThreadingProfile receiverThreadingProfile) {
        this.receiverThreadingProfile = receiverThreadingProfile;
    }

    public void destroyReceiver(MessageReceiver receiver, ImmutableEndpoint endpoint) throws Exception {
        receiver.dispose();
    }

    protected abstract void doInitialise() throws InitialisationException;

    protected abstract void doDispose();

    protected abstract void doStart() throws MuleException;

    protected abstract void doStop() throws MuleException;

    public List getDefaultInboundTransformers() {
        if (this.serviceDescriptor == null) {
            throw new RuntimeException("serviceDescriptor not initialized");
        }
        return TransformerUtils.getDefaultInboundTransformers(this.serviceDescriptor);
    }

    public List getDefaultResponseTransformers() {
        if (this.serviceDescriptor == null) {
            throw new RuntimeException("serviceDescriptor not initialized");
        }
        return TransformerUtils.getDefaultResponseTransformers(this.serviceDescriptor);
    }

    public List getDefaultOutboundTransformers() {
        if (this.serviceDescriptor == null) {
            throw new RuntimeException("serviceDescriptor not initialized");
        }
        return TransformerUtils.getDefaultOutboundTransformers(this.serviceDescriptor);
    }

    public ReplyToHandler getReplyToHandler() {
        return new DefaultReplyToHandler(this.getDefaultResponseTransformers());
    }

    public void fireNotification(ServerNotification notification) {
        this.cachedNotificationHandler.fireNotification(notification);
    }

    public boolean isResponseEnabled() {
        return false;
    }

    public boolean isSyncEnabled(String protocol) {
        return false;
    }

    public MessageReceiver getReceiver(Service service, InboundEndpoint endpoint) {
        if (this.receivers != null) {
            Object key = this.getReceiverKey(service, endpoint);
            if (key != null) {
                return (MessageReceiver)this.receivers.get(key);
            }
            throw new RuntimeException("getReceiverKey() returned a null key");
        }
        throw new RuntimeException("Connector has not been initialized.");
    }

    public Map getReceivers() {
        return Collections.unmodifiableMap(this.receivers);
    }

    public MessageReceiver lookupReceiver(String key) {
        if (key != null) {
            return (MessageReceiver)this.receivers.get((Object)key);
        }
        throw new IllegalArgumentException("Receiver key must not be null");
    }

    public MessageReceiver[] getReceivers(String wildcardExpression) {
        WildcardFilter filter = new WildcardFilter(wildcardExpression);
        filter.setCaseSensitive(false);
        ArrayList found = new ArrayList();
        for (Map.Entry e : this.receivers.entrySet()) {
            if (!filter.accept(e.getKey())) continue;
            found.add(e.getValue());
        }
        return (MessageReceiver[])CollectionUtils.toArrayOfComponentType(found, MessageReceiver.class);
    }

    public void connect() throws Exception {
        this.checkDisposed();
        if (this.isConnected()) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Connecting: " + this));
        }
        this.retryPolicyTemplate.execute(new RetryCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void doWork(RetryContext context) throws Exception {
                block15: {
                    if (AbstractConnector.this.validateConnections && !AbstractConnector.this.validateConnection(context).isOk()) {
                        throw new ConnectException(MessageFactory.createStaticMessage("Unable to connect to resource"), context.getLastFailure(), null);
                    }
                    AbstractConnector.this.doConnect();
                    Map info = context.getMetaInfo();
                    if (info.get("failedReceiver") != null) {
                        String receiverKey = (String)info.get("failedReceiver");
                        MessageReceiver receiver = (MessageReceiver)AbstractConnector.this.receivers.get((Object)receiverKey);
                        if (AbstractConnector.this.validateConnections && !receiver.validateConnection(context).isOk()) {
                            throw new ConnectException(MessageFactory.createStaticMessage("Unable to connect receiver to resource"), context.getLastFailure(), receiver);
                        }
                    } else {
                        if (info.get("failedDispatcher") != null) {
                            OutboundEndpoint endpoint = (OutboundEndpoint)info.get("failedDispatcher");
                            MessageDispatcher dispatcher = (MessageDispatcher)AbstractConnector.this.dispatchers.borrowObject((Object)endpoint);
                            try {
                                if (AbstractConnector.this.validateConnections && !dispatcher.validateConnection(context).isOk()) {
                                    throw new ConnectException(MessageFactory.createStaticMessage("Unable to connect dispatcher to resource"), context.getLastFailure(), null);
                                }
                                break block15;
                            }
                            finally {
                                AbstractConnector.this.dispatchers.returnObject((Object)endpoint, (Object)dispatcher);
                            }
                        }
                        if (info.get("failedRequester") != null) {
                            OutboundEndpoint endpoint = (OutboundEndpoint)info.get("failedRequester");
                            MessageRequester requester = (MessageRequester)AbstractConnector.this.requesters.borrowObject((Object)endpoint);
                            try {
                                if (AbstractConnector.this.validateConnections && !requester.validateConnection(context).isOk()) {
                                    throw new ConnectException(MessageFactory.createStaticMessage("Unable to connect requester to resource"), context.getLastFailure(), null);
                                }
                            }
                            finally {
                                AbstractConnector.this.requesters.returnObject((Object)endpoint, (Object)requester);
                            }
                        }
                    }
                }
                AbstractConnector.this.setConnected(true);
                AbstractConnector.this.logger.info((Object)("Connected: " + this.getWorkDescription()));
                if (AbstractConnector.this.startOnConnect) {
                    AbstractConnector.this.start();
                }
            }

            public String getWorkDescription() {
                return AbstractConnector.this.getConnectionDescription();
            }
        }, this.muleContext.getWorkManager());
    }

    public RetryContext validateConnection(RetryContext retryContext) {
        retryContext.setOk();
        return retryContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() throws Exception {
        block12: {
            this.startOnConnect = this.isStarted();
            this.fireNotification(new ConnectionNotification(this, this.getConnectEventId(), 703));
            this.connected.set(false);
            try {
                if (this.receivers != null) {
                    for (MessageReceiver receiver : this.receivers.values()) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("Disconnecting receiver on endpoint: " + receiver.getEndpoint().getEndpointURI()));
                        }
                        receiver.disconnect();
                    }
                }
                this.doDisconnect();
                Object var4_3 = null;
                if (this.receivers == null) break block12;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (this.receivers != null) {
                    for (MessageReceiver receiver : this.receivers.values()) {
                        if (!(receiver instanceof AbstractMessageReceiver) || !((AbstractMessageReceiver)receiver).isStarted()) continue;
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("Stopping receiver on endpoint: " + receiver.getEndpoint().getEndpointURI()));
                        }
                        receiver.stop();
                    }
                }
                if (this.isStarted()) {
                    this.stop();
                }
                throw throwable;
            }
            for (MessageReceiver receiver : this.receivers.values()) {
                if (!(receiver instanceof AbstractMessageReceiver) || !((AbstractMessageReceiver)receiver).isStarted()) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Stopping receiver on endpoint: " + receiver.getEndpoint().getEndpointURI()));
                }
                receiver.stop();
            }
        }
        if (this.isStarted()) {
            this.stop();
        }
        this.logger.info((Object)("Disconnected: " + this.getConnectionDescription()));
    }

    public String getConnectionDescription() {
        return this.toString();
    }

    public final boolean isConnected() {
        return this.connected.get();
    }

    public final void setConnected(boolean flag) {
        this.connected.set(flag);
    }

    protected abstract void doConnect() throws Exception;

    protected abstract void doDisconnect() throws Exception;

    protected String getConnectEventId() {
        return this.getName();
    }

    public boolean isCreateMultipleTransactedReceivers() {
        return this.createMultipleTransactedReceivers;
    }

    public void setCreateMultipleTransactedReceivers(boolean createMultipleTransactedReceivers) {
        this.createMultipleTransactedReceivers = createMultipleTransactedReceivers;
    }

    public int getNumberOfConcurrentTransactedReceivers() {
        return this.numberOfConcurrentTransactedReceivers;
    }

    public void setNumberOfConcurrentTransactedReceivers(int count) {
        this.numberOfConcurrentTransactedReceivers = count;
    }

    public void setDynamicNotification(boolean dynamic) {
        this.dynamicNotification = dynamic;
    }

    protected void updateCachedNotificationHandler() {
        if (null != this.muleContext) {
            this.cachedNotificationHandler = this.dynamicNotification ? this.muleContext.getNotificationManager() : new OptimisedNotificationHandler(this.muleContext.getNotificationManager(), EndpointMessageNotification.class);
        }
    }

    protected boolean isEnableMessageEvents() {
        return this.cachedNotificationHandler.isNotificationEnabled(EndpointMessageNotification.class);
    }

    public void registerSupportedProtocol(String protocol) {
        if ((protocol = protocol.toLowerCase()).startsWith(this.getProtocol().toLowerCase())) {
            this.registerSupportedProtocolWithoutPrefix(protocol);
        } else {
            this.supportedProtocols.add(this.getProtocol().toLowerCase() + ":" + protocol);
        }
    }

    protected void registerSupportedProtocolWithoutPrefix(String protocol) {
        this.supportedProtocols.add(protocol.toLowerCase());
    }

    public void unregisterSupportedProtocol(String protocol) {
        if ((protocol = protocol.toLowerCase()).startsWith(this.getProtocol().toLowerCase())) {
            this.supportedProtocols.remove(protocol);
        } else {
            this.supportedProtocols.remove(this.getProtocol().toLowerCase() + ":" + protocol);
        }
    }

    public boolean supportsProtocol(String protocol) {
        return this.supportedProtocols.contains(protocol.toLowerCase());
    }

    public List getSupportedProtocols() {
        return Collections.unmodifiableList(this.supportedProtocols);
    }

    public void setSupportedProtocols(List supportedProtocols) {
        for (String s : supportedProtocols) {
            this.registerSupportedProtocol(s);
        }
    }

    protected WorkManager getReceiverWorkManager(String receiverName) throws MuleException {
        return (WorkManager)this.receiverWorkManager.get();
    }

    protected WorkManager getDispatcherWorkManager() throws MuleException {
        return (WorkManager)this.dispatcherWorkManager.get();
    }

    protected WorkManager getRequesterWorkManager() throws MuleException {
        return (WorkManager)this.requesterWorkManager.get();
    }

    public ScheduledExecutorService getScheduler() {
        if (this.scheduler.get() == null) {
            NamedThreadFactory threadFactory = new NamedThreadFactory(this.getName() + ".scheduler");
            ScheduledThreadPoolExecutor newExecutor = new ScheduledThreadPoolExecutor(4, (ThreadFactory)threadFactory);
            newExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            newExecutor.setKeepAliveTime(this.getReceiverThreadingProfile().getThreadTTL(), TimeUnit.MILLISECONDS);
            newExecutor.allowCoreThreadTimeOut(true);
            if (!this.scheduler.compareAndSet(null, (Object)newExecutor)) {
                newExecutor.shutdown();
            }
        }
        return (ScheduledExecutorService)this.scheduler.get();
    }

    public SessionHandler getSessionHandler() {
        return this.sessionHandler;
    }

    public void setSessionHandler(SessionHandler sessionHandler) {
        this.sessionHandler = sessionHandler;
    }

    public void workAccepted(WorkEvent event) {
        this.handleWorkException(event, "workAccepted");
    }

    public void workRejected(WorkEvent event) {
        this.handleWorkException(event, "workRejected");
    }

    public void workStarted(WorkEvent event) {
        this.handleWorkException(event, "workStarted");
    }

    public void workCompleted(WorkEvent event) {
        this.handleWorkException(event, "workCompleted");
    }

    protected void handleWorkException(WorkEvent event, String type) {
        if (event == null) {
            return;
        }
        Throwable e = event.getException();
        if (e == null) {
            return;
        }
        if (e.getCause() != null) {
            e = e.getCause();
        }
        this.logger.error((Object)("Work caused exception on '" + type + "'. Work being executed was: " + event.getWork().toString()));
        if (!(e instanceof Exception)) {
            throw new MuleRuntimeException(CoreMessages.connectorCausedError(this.getName()), e);
        }
        this.handleException((Exception)e);
    }

    public void dispatch(OutboundEndpoint endpoint, MuleEvent event) throws DispatchException {
        MessageDispatcher dispatcher = null;
        try {
            dispatcher = this.getDispatcher(endpoint);
            dispatcher.dispatch(event);
        }
        catch (DispatchException dex) {
            throw dex;
        }
        catch (MuleException ex) {
            throw new DispatchException(event.getMessage(), endpoint, (Throwable)ex);
        }
        finally {
            this.returnDispatcher(endpoint, dispatcher);
        }
    }

    protected void setupDispatchReturn(final OutboundEndpoint endpoint, final MessageDispatcher dispatcher, MuleMessage result) {
        if (result != null && result.getPayload() instanceof InputStream) {
            DelegatingInputStream is = new DelegatingInputStream((InputStream)result.getPayload()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        AbstractConnector.this.returnDispatcher(endpoint, dispatcher);
                    }
                }
            };
            result.setPayload(is);
        } else {
            this.returnDispatcher(endpoint, dispatcher);
        }
    }

    public MuleMessage request(String uri, long timeout) throws Exception {
        return this.request(this.getMuleContext().getRegistry().lookupEndpointFactory().getInboundEndpoint(uri), timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MuleMessage request(InboundEndpoint endpoint, long timeout) throws Exception {
        MessageRequester requester = null;
        MuleMessage result = null;
        try {
            requester = this.getRequester(endpoint);
            MuleMessage muleMessage = result = requester.request(timeout);
            this.setupRequestReturn(endpoint, requester, result);
            return muleMessage;
        }
        catch (Throwable throwable) {
            this.setupRequestReturn(endpoint, requester, result);
            throw throwable;
        }
    }

    protected void setupRequestReturn(final InboundEndpoint endpoint, final MessageRequester requester, MuleMessage result) {
        if (result != null && result.getPayload() instanceof InputStream) {
            DelegatingInputStream is = new DelegatingInputStream((InputStream)result.getPayload()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        AbstractConnector.this.returnRequester(endpoint, requester);
                    }
                }
            };
            result.setPayload(is);
        } else {
            this.returnRequester(endpoint, requester);
        }
    }

    public MuleMessage send(OutboundEndpoint endpoint, MuleEvent event) throws DispatchException {
        MessageDispatcher dispatcher = null;
        try {
            dispatcher = this.getDispatcher(endpoint);
            MuleMessage muleMessage = dispatcher.send(event);
            return muleMessage;
        }
        catch (DispatchException dex) {
            throw dex;
        }
        catch (MuleException ex) {
            throw new DispatchException(event.getMessage(), endpoint, (Throwable)ex);
        }
        finally {
            this.returnDispatcher(endpoint, dispatcher);
        }
    }

    public void initialiseFromUrl(EndpointURI endpointUri) throws InitialisationException {
        String host;
        if (!this.supportsProtocol(endpointUri.getFullScheme())) {
            throw new InitialisationException(CoreMessages.schemeNotCompatibleWithConnector(endpointUri.getFullScheme(), this.getClass()), (Initialisable)this);
        }
        Properties props = new Properties();
        props.putAll((Map<?, ?>)endpointUri.getParams());
        if (endpointUri.getUserInfo() != null) {
            props.setProperty("username", endpointUri.getUser());
            String passwd = endpointUri.getPassword();
            if (passwd != null) {
                props.setProperty("password", passwd);
            }
        }
        if ((host = endpointUri.getHost()) != null) {
            props.setProperty("hostname", host);
            props.setProperty("host", host);
        }
        if (endpointUri.getPort() > -1) {
            props.setProperty("port", String.valueOf(endpointUri.getPort()));
        }
        BeanUtils.populateWithoutFail(this, props, true);
        this.setName(ObjectNameHelper.getConnectorName(this));
    }

    protected synchronized void initFromServiceDescriptor() throws InitialisationException {
        try {
            MessageRequesterFactory rf;
            MessageDispatcherFactory df;
            this.serviceDescriptor = (TransportServiceDescriptor)RegistryContext.getRegistry().lookupServiceDescriptor("transport", this.getProtocol().toLowerCase(), this.serviceOverrides);
            if (this.serviceDescriptor == null) {
                throw new ServiceException(CoreMessages.noServiceTransportDescriptor(this.getProtocol()));
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Loading DispatcherFactory for connector: " + this.getName() + " (" + this.getClass().getName() + ")"));
            }
            if ((df = this.serviceDescriptor.createDispatcherFactory()) != null) {
                this.setDispatcherFactory(df);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Transport '" + this.getProtocol() + "' will not support outbound endpoints: "));
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Loading RequesterFactory for connector: " + this.getName() + " (" + this.getClass().getName() + ")"));
            }
            if ((rf = this.serviceDescriptor.createRequesterFactory()) != null) {
                this.setRequesterFactory(rf);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Transport '" + this.getProtocol() + "' will not support requests: "));
            }
            this.sessionHandler = this.serviceDescriptor.createSessionHandler();
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    protected TransportServiceDescriptor getServiceDescriptor() {
        if (this.serviceDescriptor == null) {
            throw new IllegalStateException("This connector has not yet been initialised: " + this.name);
        }
        return this.serviceDescriptor;
    }

    protected MessageReceiver createReceiver(Service service, InboundEndpoint endpoint) throws Exception {
        return this.getServiceDescriptor().createMessageReceiver(this, service, endpoint);
    }

    public MessageAdapter getMessageAdapter(Object message) throws MessagingException {
        try {
            return this.serviceDescriptor.createMessageAdapter(message);
        }
        catch (TransportServiceException e) {
            throw new MessagingException(CoreMessages.failedToCreate("Message Adapter"), message, (Throwable)e);
        }
    }

    public Map getServiceOverrides() {
        return this.serviceOverrides;
    }

    public void setServiceOverrides(Map serviceOverrides) {
        this.serviceOverrides = new Properties();
        this.serviceOverrides.putAll((Map<?, ?>)serviceOverrides);
    }

    public OutputStream getOutputStream(OutboundEndpoint endpoint, MuleMessage message) throws MuleException {
        throw new UnsupportedOperationException(CoreMessages.streamingNotSupported(this.getProtocol()).toString());
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
        this.updateCachedNotificationHandler();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(120);
        sb.append(ClassUtils.getSimpleName(this.getClass()));
        sb.append("{this=").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(", started=").append(this.started);
        sb.append(", initialised=").append(this.initialised);
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", disposed=").append(this.disposed);
        sb.append(", numberOfConcurrentTransactedReceivers=").append(this.numberOfConcurrentTransactedReceivers);
        sb.append(", createMultipleTransactedReceivers=").append(this.createMultipleTransactedReceivers);
        sb.append(", connected=").append(this.connected);
        sb.append(", supportedProtocols=").append(this.supportedProtocols);
        sb.append(", serviceOverrides=").append(this.serviceOverrides);
        sb.append('}');
        return sb.toString();
    }

    public RetryPolicyTemplate getRetryPolicyTemplate() {
        return this.retryPolicyTemplate;
    }

    public void setRetryPolicyTemplate(RetryPolicyTemplate retryPolicyTemplate) {
        this.retryPolicyTemplate = retryPolicyTemplate;
    }

    public boolean isValidateConnections() {
        return this.validateConnections;
    }

    public void setValidateConnections(boolean validateConnections) {
        this.validateConnections = validateConnections;
    }
}

